/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.util;

import io.hanko.sdk.exception.HankoClientException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;

public class HmacUtil {
    private HmacUtil() {
    }

    public static String makeAuthorizationHeader(String apiSecret, String apiKeyId, String method, String path, String content) {
        if (apiKeyId == null) {
            return "secret " + apiSecret;
        }
        return HmacUtil.makeHmacAuthorizationHeader(apiSecret, apiKeyId, method, path, content);
    }

    private static String makeHmacAuthorizationHeader(String apiSecret, String apiKeyId, String method, String path, String content) {
        try {
            long date = Instant.now().getEpochSecond();
            String nonce = UUID.randomUUID().toString();
            String trimmedPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            String stringToSign = String.format("%s:%d:%s:%s:%s", apiKeyId, date, method, trimmedPath, nonce);
            if (content != null && !content.equals("")) {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(content.getBytes(StandardCharsets.UTF_8));
                String hashHexed = Hex.encodeHexString((byte[])hash);
                stringToSign = String.format("%s:%s", stringToSign, hashHexed);
            }
            SecretKeySpec keySpec = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), HmacAlgorithms.HMAC_SHA_256.getName());
            Mac mac = Mac.getInstance(HmacAlgorithms.HMAC_SHA_256.getName());
            mac.init(keySpec);
            byte[] signatureBytes = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String signatureHex = Hex.encodeHexString((byte[])signatureBytes);
            String jsonFormat = "{\"apiKeyId\":\"%s\",\"time\":\"%d\",\"nonce\":\"%s\",\"signature\":\"%s\"}";
            String jsonRepresentation = String.format(jsonFormat, apiKeyId, date, nonce, signatureHex);
            Base64.Encoder base64Encoder = Base64.getEncoder().withoutPadding();
            String base64Representation = base64Encoder.encodeToString(jsonRepresentation.getBytes(StandardCharsets.UTF_8));
            return "hanko " + base64Representation;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new HankoClientException("Could not calculate HMAC: " + ex.getMessage(), ex);
        }
    }
}

