/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.http;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class HankoHttpResponse {
    private final InputStream stream;
    private final int statusCode;
    private final String requestPath;

    public HankoHttpResponse(InputStream stream, int statusCode, String requestPath) {
        this.stream = stream;
        this.statusCode = statusCode;
        this.requestPath = requestPath;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContent() {
        if (this.stream != null) {
            Scanner scanner = new Scanner(this.stream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
            if (!scanner.hasNext()) {
                return "";
            }
            String content = scanner.next();
            scanner.close();
            return content;
        }
        return "";
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public boolean success() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }
}

