/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.http;

import io.hanko.sdk.config.HankoClientConfig;
import io.hanko.sdk.exception.HankoApiException;
import io.hanko.sdk.exception.HankoAuthenticationException;
import io.hanko.sdk.exception.HankoNotFoundException;
import io.hanko.sdk.http.HankoHttpClientBase;
import io.hanko.sdk.http.HankoHttpResponse;
import io.hanko.sdk.http.HttpMethod;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HankoHttpClient
extends HankoHttpClientBase {
    public HankoHttpClient(HankoClientConfig config) {
        this(config, HttpClients.createDefault());
    }

    public HankoHttpClient(HankoClientConfig config, CloseableHttpClient httpClient) {
        super(config, httpClient);
    }

    public HankoHttpResponse post(String path, String body) {
        HankoHttpResponse response = this.makeRequest(HttpMethod.POST, path, body);
        if (!response.success()) {
            this.handleErrorResponse(response);
        }
        return response;
    }

    public HankoHttpResponse get(String path) {
        HankoHttpResponse response = this.makeRequest(HttpMethod.GET, path);
        if (!response.success()) {
            this.handleErrorResponse(response);
        }
        return response;
    }

    public HankoHttpResponse put(String path, String body) {
        HankoHttpResponse response = this.makeRequest(HttpMethod.PUT, path, body);
        if (!response.success()) {
            this.handleErrorResponse(response);
        }
        return response;
    }

    public HankoHttpResponse delete(String path) {
        HankoHttpResponse response = this.makeRequest(HttpMethod.DELETE, path);
        if (!response.success()) {
            this.handleErrorResponse(response);
        }
        return response;
    }

    private void handleErrorResponse(HankoHttpResponse response) {
        if (response.getStatusCode() == 401) {
            throw new HankoAuthenticationException("Hanko API returned 401, please check your API key configuration", response.getStatusCode(), response.getRequestPath(), response.getContent());
        }
        if (response.getStatusCode() == 404) {
            String message = String.format("Hanko API resource '%s' not found.", response.getRequestPath());
            throw new HankoNotFoundException(message, response.getStatusCode(), response.getContent(), response.getRequestPath());
        }
        throw new HankoApiException("Hanko API returned an unexpected status code", response.getStatusCode(), response.getRequestPath(), response.getContent());
    }

    @Override
    protected Logger getLogger() {
        return LoggerFactory.getLogger(HankoHttpClient.class);
    }
}

