/*
 * Decompiled with CFR 0.152.
 */
package io.hanko.sdk.config;

import io.hanko.sdk.exception.HankoClientException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class HankoClientConfig {
    private final URL apiUrl;
    private final String apiKeyId;
    private final String apiSecret;

    public HankoClientConfig(String apiUrl, String apiSecret) {
        this(apiUrl, apiSecret, null);
    }

    public HankoClientConfig(String apiUrl, String apiSecret, String apiKeyId) {
        try {
            this.apiUrl = new URL(apiUrl);
        }
        catch (MalformedURLException ex) {
            throw new HankoClientException("apiUrl must be valid URL", ex);
        }
        this.apiSecret = Objects.requireNonNull(apiSecret, "apiSecret must not be null");
        this.apiKeyId = apiKeyId;
    }

    public URL getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }
}

