/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.validate;

import io.growing.sdk.java.dto.GIOEventMessage;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import java.util.Arrays;
import java.util.List;

public class MsgValidate {
    private static final List<String> INVALID_CS1_VALUE = Arrays.asList("0", "1", "-1");
    private static final int STRING_VALUE_LENGTH_LIMIT = 255;

    public static GIOMessage validate(GIOMessage msg) {
        GIOEventMessage eventMessage;
        if (msg instanceof GIOEventMessage && MsgValidate.isGIOEventMessageInvalidate(eventMessage = (GIOEventMessage)msg)) {
            return null;
        }
        return msg;
    }

    private static boolean isGIOEventMessageInvalidate(GIOEventMessage gioEventMessage) {
        if (gioEventMessage.getN() == null) {
            GioLogger.error("event key cant be null ");
            return true;
        }
        int nLength = gioEventMessage.getN().length();
        if (nLength == 0 || nLength > 255) {
            GioLogger.error("event key length must be between 1 and 255 ");
            return true;
        }
        if (gioEventMessage.getCs1() != null) {
            int cs1Length = gioEventMessage.getCs1().length();
            if (cs1Length == 0 || cs1Length > 255) {
                GioLogger.error("event loginUserId length must be between 1 and 255 ");
                return true;
            }
            if (INVALID_CS1_VALUE.contains(gioEventMessage.getCs1())) {
                GioLogger.error("event loginUserId cant contains " + gioEventMessage.getCs1());
                return true;
            }
            if (gioEventMessage.getCs1().contains(":")) {
                GioLogger.error("event loginUserId cant contains [:]" + gioEventMessage.getCs1());
                return true;
            }
        }
        return false;
    }
}

