/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender.net;

import io.growing.sdk.java.GrowingAPI;
import io.growing.sdk.java.constants.APIConstants;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.utils.ConfigUtils;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class NetProviderAbstract {
    protected static final String CHECK_NET_HEALTH_URL = APIConstants.getApihost();
    protected static final Map<String, String> httpHeaders = new HashMap<String, String>();
    protected static final int connectionTimeout = ConfigUtils.getIntValue("connection.timeout", 2000);
    protected static final int readTimeout = ConfigUtils.getIntValue("read.timeout", 2000);
    private static final String COMPRESS_HEADER = "X-Compress-Codec";
    private static final Boolean compressConfig = ConfigUtils.getBooleanValue("compress", Boolean.TRUE);

    public static boolean needCompress() {
        return compressConfig;
    }

    public void toSend(String url, byte[] data) {
        if (GrowingAPI.isProductionMode()) {
            this.sendPost(url, data);
        } else {
            GioLogger.debug("apiHost: " + url + " data size: " + data.length);
        }
    }

    protected abstract void sendPost(String var1, byte[] var2);

    protected abstract void sendGet(String var1) throws IOException;

    public abstract boolean isConnectedToGrowingAPIHost();

    static {
        String compressCode = "0";
        if (compressConfig.booleanValue()) {
            compressCode = "2";
        }
        httpHeaders.put(COMPRESS_HEADER, compressCode);
    }

    protected static class ProxyInfo {
        private static Proxy proxy = ProxyInfo.setProxy();

        protected ProxyInfo() {
        }

        private static Proxy setProxy() {
            String proxyHost = ConfigUtils.getStringValue("proxy.host", null);
            Integer proxyPort = ConfigUtils.getIntValue("proxy.port", 80);
            if (proxyHost == null || proxyHost.isEmpty()) {
                return null;
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
        }

        private static void setAuthenticator() {
            final String proxyUser = ConfigUtils.getStringValue("proxy.user", null);
            final String proxyPassword = ConfigUtils.getStringValue("proxy.password", null);
            if (proxyUser != null && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }

        public static Proxy getProxy() {
            return proxy;
        }

        static {
            ProxyInfo.setAuthenticator();
        }
    }
}

