/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.process.serialize;

import io.growing.sdk.java.GrowingAPI;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.process.serialize.SerializeTool;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSerialize
implements SerializeTool {
    @Override
    public byte[] serialize(List<GIOMessage> msgList) {
        String serialized = JsonSerialize.serializeToJson(msgList);
        if (GrowingAPI.isTestMode()) {
            GioLogger.debug("gio message is " + serialized);
        }
        return serialized.getBytes();
    }

    @Override
    public String deserialize(byte[] bytes) {
        return new String(bytes);
    }

    public static String serializeToJson(List<GIOMessage> msgList) {
        JSONArray jsonArray = new JSONArray();
        for (GIOMessage msg : msgList) {
            jsonArray.put((Object)new JSONObject(msg.getMapResult()));
        }
        return jsonArray.toString();
    }

    public static String serializeToJson(GIOMessage msg) {
        return new JSONObject((Object)msg).toString();
    }
}

