/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.UnableToBuildJsonQueryException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphQLRequestSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private GraphQLRequestSerializer() {
    }

    public static String toHttpJsonBody(GraphQLRequest graphQLRequest) {
        return GraphQLRequestSerializer.buildQuery(graphQLRequest, true);
    }

    public static String toQueryString(GraphQLRequest graphQLRequest) {
        return GraphQLRequestSerializer.buildQuery(graphQLRequest, false);
    }

    private static String buildQuery(GraphQLRequest graphQLRequest, boolean jsonQuery) {
        if (graphQLRequest == null || graphQLRequest.getRequest() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(graphQLRequest.getRequest().getOperationType().name().toLowerCase());
        builder.append(" { ");
        builder.append(graphQLRequest.getRequest().getOperationName());
        Map<String, Object> input = graphQLRequest.getRequest().getInput();
        if (input != null && !input.isEmpty()) {
            builder.append("(");
            Iterator<Map.Entry<String, Object>> inputEntryIterator = input.entrySet().iterator();
            boolean valueAdded = false;
            while (inputEntryIterator.hasNext()) {
                Map.Entry<String, Object> inputEntry = inputEntryIterator.next();
                if (inputEntry.getValue() == null) continue;
                if (valueAdded) {
                    builder.append(", ");
                }
                builder.append(inputEntry.getKey());
                builder.append(": ");
                builder.append(GraphQLRequestSerializer.getEntry(inputEntry.getValue(), jsonQuery));
                valueAdded = true;
            }
            builder.append(")");
        }
        if (graphQLRequest.getResponseProjection() != null) {
            builder.append(graphQLRequest.getResponseProjection().toString());
        }
        builder.append(" }");
        String query = builder.toString();
        return jsonQuery ? GraphQLRequestSerializer.buildJsonQuery(query) : query;
    }

    private static String buildJsonQuery(String queryString) {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("query", queryString);
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new UnableToBuildJsonQueryException((Exception)((Object)e));
        }
    }

    public static String getEntry(Object input) {
        return GraphQLRequestSerializer.getEntry(input, true);
    }

    private static String getEntry(Object input, boolean jsonQuery) {
        if (input == null) {
            return null;
        }
        if (input instanceof Collection) {
            Collection inputCollection = (Collection)input;
            return inputCollection.stream().map(i -> GraphQLRequestSerializer.getEntry(i, jsonQuery)).collect(Collectors.joining(", ", "[ ", " ]"));
        }
        if (input instanceof Enum) {
            return input.toString();
        }
        if (input instanceof String) {
            return GraphQLRequestSerializer.escapeJsonString(input.toString());
        }
        return input.toString();
    }

    public static String escapeJsonString(String stringValue) {
        int len = stringValue.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append("\"");
        block9: for (int i = 0; i < len; ++i) {
            char ch = stringValue.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

