/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.mapper.ValueFormatter;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValueMapper {
    private static final String NULL_STRING = "null";

    private ValueMapper() {
    }

    public static String map(MappingContext mappingContext, Value<?> value, Type<?> graphQLType) {
        return ValueMapper.map(mappingContext, value, graphQLType, null);
    }

    public static String map(MappingContext mappingContext, Value<?> value, Type<?> graphQLType, String formatter) {
        if (value instanceof NullValue) {
            return ValueFormatter.format(NULL_STRING, formatter);
        }
        if (value instanceof BooleanValue) {
            return ValueFormatter.format(ValueMapper.mapBoolean((BooleanValue)value), formatter);
        }
        if (value instanceof IntValue) {
            return ValueFormatter.format(ValueMapper.mapInt(mappingContext, (IntValue)value, graphQLType), formatter);
        }
        if (value instanceof FloatValue) {
            return ValueFormatter.format(ValueMapper.mapFloat((FloatValue)value), formatter);
        }
        if (value instanceof StringValue) {
            return ValueFormatter.format(ValueMapper.mapString((StringValue)value), formatter);
        }
        if (value instanceof EnumValue) {
            return ValueFormatter.format(ValueMapper.mapEnum(mappingContext, (EnumValue)value, graphQLType), formatter);
        }
        if (value instanceof ObjectValue) {
            return null;
        }
        if (value instanceof ArrayValue) {
            return ValueMapper.mapArray(mappingContext, (ArrayValue)value, graphQLType, formatter);
        }
        return null;
    }

    private static String mapBoolean(BooleanValue value) {
        return value.isValue() ? "true" : "false";
    }

    private static String mapInt(MappingContext mappingContext, IntValue value, Type<?> graphQLType) {
        if (graphQLType instanceof TypeName) {
            String customType = mappingContext.getCustomTypesMapping().get("Long");
            String typeName = ((TypeName)graphQLType).getName();
            if ("Long".equals(typeName) && ("java.lang.Long".equals(customType) || "Long".equals(customType))) {
                return String.valueOf(value.getValue()).concat("L");
            }
        }
        if (graphQLType instanceof NonNullType) {
            return ValueMapper.mapInt(mappingContext, value, ((NonNullType)graphQLType).getType());
        }
        return String.valueOf(value.getValue());
    }

    private static String mapFloat(FloatValue value) {
        return String.valueOf(value.getValue());
    }

    private static String mapString(StringValue value) {
        return "\"" + value.getValue() + "\"";
    }

    private static String mapEnum(MappingContext mappingContext, EnumValue value, Type<?> graphQLType) {
        if (graphQLType instanceof TypeName) {
            String typeName = ((TypeName)graphQLType).getName();
            typeName = MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName);
            return typeName + "." + MapperUtils.capitalizeIfRestricted(value.getName());
        }
        if (graphQLType instanceof NonNullType) {
            return ValueMapper.mapEnum(mappingContext, value, ((NonNullType)graphQLType).getType());
        }
        throw new IllegalArgumentException("Unexpected Enum value for list type");
    }

    private static String mapArray(MappingContext mappingContext, ArrayValue value, Type<?> graphQLType, String formatter) {
        if (graphQLType == null || graphQLType instanceof ListType) {
            List values = value.getValues();
            if (values.isEmpty()) {
                return ValueFormatter.formatList(Collections.emptyList(), formatter);
            }
            Type elementType = null;
            if (graphQLType != null) {
                elementType = ((ListType)graphQLType).getType();
            }
            Type listElementType = elementType;
            return ValueFormatter.formatList(values.stream().map(v -> ValueMapper.map(mappingContext, v, listElementType, formatter)).collect(Collectors.toList()), formatter);
        }
        if (graphQLType instanceof NonNullType) {
            return ValueMapper.mapArray(mappingContext, value, ((NonNullType)graphQLType).getType(), formatter);
        }
        throw new IllegalArgumentException("Unexpected array default value for non-list type");
    }
}

