/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import java.util.List;
import java.util.StringJoiner;

public class ValueFormatter {
    public static final String FORMATTER_TO_STRING = "?toString";
    public static final String FORMATTER_TO_ARRAY = "?toArray";
    public static final String FORMATTER_TO_ARRAY_OF_STRINGS = "?toArrayOfStrings";

    private ValueFormatter() {
    }

    public static String formatList(List<String> values, String formatter) {
        if (values == null) {
            return ValueFormatter.format("null", formatter);
        }
        if (formatter == null) {
            if (values.isEmpty()) {
                return "java.util.Collections.emptyList()";
            }
            StringJoiner listJoiner = new StringJoiner(", ", "java.util.Arrays.asList(", ")");
            values.forEach(listJoiner::add);
            return listJoiner.toString();
        }
        switch (formatter) {
            case "?toArrayOfStrings": {
                StringJoiner arrayOfStringsJoiner = new StringJoiner(", ", "{", "}");
                values.forEach(newElement -> arrayOfStringsJoiner.add(ValueFormatter.format(newElement, FORMATTER_TO_STRING)));
                return arrayOfStringsJoiner.toString();
            }
        }
        StringJoiner listValuesJoiner = new StringJoiner(", ", "{", "}");
        values.forEach(listValuesJoiner::add);
        return listValuesJoiner.toString();
    }

    public static String format(String value, String formatter) {
        return FORMATTER_TO_STRING.equals(formatter) ? "\"" + value + "\"" : value;
    }
}

