/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GraphqlTypeToJavaTypeMapper {
    private static final String JAVA_UTIL_LIST = "java.util.List";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";

    private GraphqlTypeToJavaTypeMapper() {
    }

    public static String getNestedTypeName(Type<?> graphqlType) {
        if (graphqlType instanceof TypeName) {
            return ((TypeName)graphqlType).getName();
        }
        if (graphqlType instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((ListType)graphqlType).getType());
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getNestedTypeName(((NonNullType)graphqlType).getType());
        }
        return null;
    }

    static String getJavaType(MappingContext mappingContext, Type<?> type) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, type, null, null).getName();
    }

    static NamedDefinition getJavaType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName) {
        return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, graphqlType, name, parentTypeName, false);
    }

    static NamedDefinition getJavaType(MappingContext mappingContext, Type<?> graphqlType, String name, String parentTypeName, boolean mandatory) {
        if (graphqlType instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((TypeName)graphqlType).getName(), name, parentTypeName, mandatory);
        }
        if (graphqlType instanceof ListType) {
            NamedDefinition mappedCollectionType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((ListType)graphqlType).getType(), name, parentTypeName, false);
            if (mappedCollectionType.isInterface() && mappingContext.getInterfacesName().contains(parentTypeName)) {
                mappedCollectionType.setName(GraphqlTypeToJavaTypeMapper.wrapSuperTypeIntoJavaList(mappedCollectionType.getName()));
            } else {
                mappedCollectionType.setName(GraphqlTypeToJavaTypeMapper.wrapIntoJavaList(mappedCollectionType.getName()));
            }
            return mappedCollectionType;
        }
        if (graphqlType instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, ((NonNullType)graphqlType).getType(), name, parentTypeName, true);
        }
        throw new IllegalArgumentException("Unknown type: " + graphqlType);
    }

    private static NamedDefinition getJavaType(MappingContext mappingContext, String graphQLType, String name, String parentTypeName, boolean mandatory) {
        Map<String, String> customTypesMapping = mappingContext.getCustomTypesMapping();
        String javaTypeName = name != null && parentTypeName != null && customTypesMapping.containsKey(parentTypeName + "." + name) ? customTypesMapping.get(parentTypeName + "." + name) : (customTypesMapping.containsKey(graphQLType) ? customTypesMapping.get(graphQLType) : MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, graphQLType));
        return new NamedDefinition(javaTypeName, mappingContext.getInterfacesName().contains(graphQLType), mandatory);
    }

    static List<String> getAnnotations(MappingContext mappingContext, Type<?> type, NamedNode<?> def, String parentTypeName, boolean mandatory) {
        if (type instanceof ListType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((ListType)type).getType(), def, parentTypeName, mandatory);
        }
        if (type instanceof NonNullType) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((NonNullType)type).getType(), def, parentTypeName, true);
        }
        if (type instanceof TypeName) {
            return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, ((TypeName)type).getName(), def.getName(), parentTypeName, GraphqlTypeToJavaTypeMapper.getDirectives(def), mandatory);
        }
        return Collections.emptyList();
    }

    static List<String> getAnnotations(MappingContext mappingContext, ExtendedDefinition<?, ?> extendedDefinition) {
        return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, extendedDefinition.getName(), extendedDefinition.getName(), null, Collections.emptyList(), false);
    }

    static List<String> getAnnotations(MappingContext mappingContext, String name) {
        return GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, name, name, null, Collections.emptyList(), false);
    }

    private static List<String> getAnnotations(MappingContext mappingContext, String graphQLTypeName, String name, String parentTypeName, List<Directive> directives, boolean mandatory) {
        List<String> annotationsToAdd;
        String modelValidationAnnotation;
        ArrayList<String> annotations = new ArrayList<String>();
        if (mandatory && Utils.isNotBlank(modelValidationAnnotation = mappingContext.getModelValidationAnnotation())) {
            annotations.add(modelValidationAnnotation);
        }
        Map<String, List<String>> customAnnotationsMapping = mappingContext.getCustomAnnotationsMapping();
        if (name != null && parentTypeName != null && customAnnotationsMapping.containsKey(parentTypeName + "." + name)) {
            annotationsToAdd = customAnnotationsMapping.get(parentTypeName + "." + name);
            if (!Utils.isEmpty(annotationsToAdd)) {
                annotations.addAll(annotationsToAdd);
            }
        } else if (customAnnotationsMapping.containsKey(graphQLTypeName) && !Utils.isEmpty(annotationsToAdd = customAnnotationsMapping.get(graphQLTypeName))) {
            annotations.addAll(annotationsToAdd);
        }
        Map<String, List<String>> directiveAnnotationsMapping = mappingContext.getDirectiveAnnotationsMapping();
        for (Directive directive : directives) {
            if (!directiveAnnotationsMapping.containsKey(directive.getName())) continue;
            annotations.addAll(GraphqlTypeToJavaTypeMapper.getAnnotationForDirective(mappingContext, directiveAnnotationsMapping.get(directive.getName()), directive));
        }
        return annotations;
    }

    private static List<String> getAnnotationForDirective(MappingContext mappingContext, List<String> directiveAnnotations, Directive directive) {
        ArrayList<String> directiveAnnotationsMapped = new ArrayList<String>();
        Iterator<String> iterator = directiveAnnotations.iterator();
        while (iterator.hasNext()) {
            String annotation;
            String directiveAnnotationMapped = annotation = iterator.next();
            for (Argument dirArg : directive.getArguments()) {
                String argumentValueFormatter = Utils.substringBetween(annotation, "{{" + dirArg.getName(), "}}");
                if (argumentValueFormatter == null) continue;
                directiveAnnotationMapped = directiveAnnotationMapped.replace(String.format("{{%s%s}}", dirArg.getName(), argumentValueFormatter), ValueMapper.map(mappingContext, dirArg.getValue(), null, argumentValueFormatter));
            }
            directiveAnnotationsMapped.add(directiveAnnotationMapped);
        }
        return directiveAnnotationsMapped;
    }

    private static String wrapIntoJavaList(String type) {
        return GraphqlTypeToJavaTypeMapper.getGenericsString(JAVA_UTIL_LIST, type);
    }

    private static String wrapSuperTypeIntoJavaList(String type) {
        return GraphqlTypeToJavaTypeMapper.getGenericsString(JAVA_UTIL_LIST, "? extends " + type);
    }

    static String wrapApiReturnTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        String javaTypeName = namedDefinition.getName();
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name())) {
            if (Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
                return GraphqlTypeToJavaTypeMapper.getGenericsString(mappingContext.getSubscriptionReturnType(), javaTypeName);
            }
        } else if (Boolean.TRUE.equals(mappingContext.getUseOptionalForNullableReturnTypes())) {
            if (!namedDefinition.isMandatory() && !javaTypeName.startsWith(JAVA_UTIL_LIST)) {
                return GraphqlTypeToJavaTypeMapper.getGenericsString(JAVA_UTIL_OPTIONAL, javaTypeName);
            }
        } else {
            if (javaTypeName.startsWith(JAVA_UTIL_LIST) && Utils.isNotBlank(mappingContext.getApiReturnListType())) {
                return javaTypeName.replace(JAVA_UTIL_LIST, mappingContext.getApiReturnListType());
            }
            if (Utils.isNotBlank(mappingContext.getApiReturnType())) {
                return GraphqlTypeToJavaTypeMapper.getGenericsString(mappingContext.getApiReturnType(), javaTypeName);
            }
        }
        return javaTypeName;
    }

    static String getGenericsString(String genericType, String typeParameter) {
        return String.format("%s<%s>", genericType, typeParameter);
    }

    private static List<Directive> getDirectives(NamedNode<?> def) {
        if (def instanceof DirectivesContainer) {
            return ((DirectivesContainer)def).getDirectives();
        }
        return Collections.emptyList();
    }
}

