/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.OperationDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.RelayConfig;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.StringValue;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldDefinitionsToResolverDataModelMapper {
    private FieldDefinitionsToResolverDataModelMapper() {
    }

    public static Map<String, Object> mapToTypeResolver(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefs, String parentTypeName) {
        String className = MapperUtils.getTypeResolverClassNameWithPrefixAndSuffix(mappingContext, parentTypeName);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, parentTypeName, className, fieldDefs, Collections.singletonList("Resolver for " + parentTypeName), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, parentTypeName));
    }

    public static Map<String, Object> mapRootTypeField(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, String rootTypeName, List<String> fieldNames) {
        String className = MapperUtils.getApiClassNameWithPrefixAndSuffix(mappingContext, fieldDefinition, rootTypeName, fieldNames);
        List<ExtendedFieldDefinition> fieldDefs = Collections.singletonList(fieldDefinition);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, rootTypeName, className, fieldDefs, fieldDefinition.getJavaDoc(), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, rootTypeName));
    }

    public static Map<String, Object> mapRootTypeFields(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        String className = MapperUtils.getApiClassNameWithPrefixAndSuffix(mappingContext, definition);
        return FieldDefinitionsToResolverDataModelMapper.mapToResolverModel(mappingContext, definition.getName(), className, definition.getFieldDefinitions(), definition.getJavaDoc(), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, definition.getName()));
    }

    private static Map<String, Object> mapToResolverModel(MappingContext mappingContext, String parentTypeName, String className, List<ExtendedFieldDefinition> fieldDefinitions, List<String> javaDoc, String parentInterface) {
        String packageName = MapperUtils.getApiPackageName(mappingContext);
        Set<String> imports = MapperUtils.getImports(mappingContext, packageName);
        List<OperationDefinition> operations = FieldDefinitionsToResolverDataModelMapper.mapToOperations(mappingContext, fieldDefinitions, parentTypeName);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", packageName);
        dataModel.put("imports", imports);
        dataModel.put("className", className);
        dataModel.put("operations", operations);
        dataModel.put("javaDoc", javaDoc);
        dataModel.put("implements", parentInterface != null ? Collections.singletonList(parentInterface) : null);
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static List<OperationDefinition> mapToOperations(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().map(fieldDef -> FieldDefinitionsToResolverDataModelMapper.map(mappingContext, fieldDef, parentTypeName)).collect(Collectors.toList());
    }

    private static OperationDefinition map(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        String name = MapperUtils.capitalizeIfRestricted(fieldDef.getName());
        NamedDefinition javaType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName);
        String returnType = FieldDefinitionsToResolverDataModelMapper.getReturnType(mappingContext, fieldDef, javaType, parentTypeName);
        List<String> annotations = GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, fieldDef.getType(), fieldDef, parentTypeName, false);
        List<ParameterDefinition> parameters = FieldDefinitionsToResolverDataModelMapper.getOperationParameters(mappingContext, fieldDef, parentTypeName);
        OperationDefinition operation = new OperationDefinition();
        operation.setName(name);
        operation.setOriginalName(fieldDef.getName());
        operation.setType(returnType);
        operation.setAnnotations(annotations);
        operation.setParameters(parameters);
        operation.setJavaDoc(fieldDef.getJavaDoc());
        operation.setDeprecated(fieldDef.isDeprecated());
        return operation;
    }

    private static List<ParameterDefinition> getOperationParameters(MappingContext mappingContext, ExtendedFieldDefinition resolvedField, String parentTypeName) {
        ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
        if (!Utils.isGraphqlOperation(parentTypeName)) {
            String parentObjectParamType = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, new TypeName(parentTypeName));
            String parentObjectParamName = MapperUtils.capitalizeIfRestricted(Utils.uncapitalize(parentObjectParamType));
            parameters.add(new ParameterDefinition(parentObjectParamType, parentObjectParamName, parentObjectParamName, null, Collections.emptyList(), Collections.emptyList(), resolvedField.isDeprecated()));
        }
        parameters.addAll(InputValueDefinitionToParameterMapper.map(mappingContext, resolvedField.getInputValueDefinitions(), resolvedField.getName()));
        if (Boolean.TRUE.equals(mappingContext.getGenerateDataFetchingEnvironmentArgumentInApis())) {
            parameters.add(ParameterDefinition.DATA_FETCHING_ENVIRONMENT);
        }
        return parameters;
    }

    public static String getParentInterface(MappingContext mappingContext, String typeName) {
        try {
            switch (GraphQLOperation.valueOf(typeName.toUpperCase())) {
                case QUERY: {
                    return mappingContext.getQueryResolverParentInterface();
                }
                case MUTATION: {
                    return mappingContext.getMutationResolverParentInterface();
                }
                case SUBSCRIPTION: {
                    return mappingContext.getSubscriptionResolverParentInterface();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mappingContext.getResolverParentInterface() == null) {
            return null;
        }
        return mappingContext.getResolverParentInterface().replace("{{TYPE}}", MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName));
    }

    private static String getReturnType(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, NamedDefinition namedDefinition, String parentTypeName) {
        Argument argument;
        Directive connectionDirective;
        RelayConfig relayConfig = mappingContext.getRelayConfig();
        if (relayConfig != null && relayConfig.getDirectiveName() != null && (connectionDirective = fieldDef.getDirective(relayConfig.getDirectiveName())) != null && (argument = connectionDirective.getArgument(relayConfig.getDirectiveArgumentName())) != null && argument.getValue() instanceof StringValue) {
            String graphqlTypeName = ((StringValue)argument.getValue()).getValue();
            String javaTypeName = GraphqlTypeToJavaTypeMapper.getJavaType(mappingContext, new TypeName(graphqlTypeName), graphqlTypeName, parentTypeName, false).getName();
            return GraphqlTypeToJavaTypeMapper.getGenericsString(relayConfig.getConnectionType(), javaTypeName);
        }
        return GraphqlTypeToJavaTypeMapper.wrapApiReturnTypeIfRequired(mappingContext, namedDefinition, parentTypeName);
    }
}

