/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.GraphqlTypeToJavaTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperUtils;
import com.kobylynskyi.graphql.codegen.model.EnumValueDefinition;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumDefinitionToDataModelMapper {
    private EnumDefinitionToDataModelMapper() {
    }

    public static Map<String, Object> map(MappingContext mappingContext, ExtendedEnumTypeDefinition definition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", MapperUtils.getModelPackageName(mappingContext));
        dataModel.put("className", MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("implements", EnumDefinitionToDataModelMapper.getUnionInterfaces(mappingContext, definition));
        dataModel.put("annotations", GraphqlTypeToJavaTypeMapper.getAnnotations(mappingContext, definition));
        dataModel.put("javaDoc", definition.getJavaDoc());
        dataModel.put("fields", EnumDefinitionToDataModelMapper.map(definition.getValueDefinitions()));
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        return dataModel;
    }

    private static Set<String> getUnionInterfaces(MappingContext mappingContext, ExtendedEnumTypeDefinition definition) {
        return mappingContext.getDocument().getUnionDefinitions().stream().filter(union -> union.isDefinitionPartOfUnion(definition)).map(ExtendedDefinition::getName).map(unionName -> MapperUtils.getModelClassNameWithPrefixAndSuffix(mappingContext, unionName)).collect(Collectors.toSet());
    }

    private static List<EnumValueDefinition> map(List<graphql.language.EnumValueDefinition> enumValueDefinitions) {
        return enumValueDefinitions.stream().map(f -> new EnumValueDefinition(MapperUtils.capitalizeIfRestricted(f.getName()), f.getName(), EnumDefinitionToDataModelMapper.getJavaDoc(f), EnumDefinitionToDataModelMapper.isDeprecated(f))).collect(Collectors.toList());
    }

    private static boolean isDeprecated(DirectivesContainer<?> directivesContainer) {
        return directivesContainer.getDirectives().stream().map(Directive::getName).anyMatch(Deprecated.class.getSimpleName()::equalsIgnoreCase);
    }

    private static List<String> getJavaDoc(graphql.language.EnumValueDefinition def) {
        if (def.getDescription() != null) {
            return Collections.singletonList(def.getDescription().getContent());
        }
        if (def.getComments() == null) {
            return Collections.emptyList();
        }
        return def.getComments().stream().map(Comment::getContent).filter(Utils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }
}

