/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.extension.utils;

import com.kobylynskyi.graphql.codegen.extension.GrowingIOConfig;
import com.kobylynskyi.graphql.codegen.extension.utils.Jackson;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequest;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OkHttpUtils {
    private static OkHttpClient client;
    private static final String DEFAULT_MEDIA_TYPE = "application/json; charset=utf-8";
    private static final int CONNECT_TIMEOUT = 5;
    private static final int READ_TIMEOUT = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OkHttpClient getInstance() {
        if (client != null) return client;
        Class<OkHttpClient> clazz = OkHttpClient.class;
        synchronized (OkHttpClient.class) {
            if (client != null) return client;
            client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.MINUTES).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public static <T> T executeGraphQLRemote(GrowingIOConfig growingIOConfig, GraphQLRequest graphQLRequest, Class<T> javaClass) throws Exception {
        Response response;
        if (growingIOConfig == null) {
            throw new Exception("exception in OkHttpUtils, GrowingIOConfig must be not equals to null");
        }
        if (growingIOConfig.getGraphQLServerHost() == null) {
            throw new Exception("exception in OkHttpUtils, graphQLServerHost must be not equals to null");
        }
        Request.Builder request = new Request.Builder().url(growingIOConfig.getGraphQLServerHost()).post(RequestBody.create((String)graphQLRequest.toHttpJsonBody(), (MediaType)MediaType.parse((String)DEFAULT_MEDIA_TYPE)));
        Map<String, String> headers = growingIOConfig.getHeaders();
        if (!headers.isEmpty()) {
            for (String header : headers.keySet()) {
                request.addHeader(header, headers.get(header));
            }
        }
        if ((response = OkHttpUtils.getInstance().newCall(request.build()).execute()).code() == 200 && response.body() != null) {
            Object ret = Jackson.mapper().readValue(response.body().string(), javaClass);
            return (T)ret;
        }
        throw new Exception("exception in OkHttpUtils, response body is: " + response.toString());
    }

    private OkHttpUtils() {
    }
}

