/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.model.exception.UnableToCreateFileException;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;

class GraphQLCodegenFileCreator {
    private static final String EXTENSION = ".java";

    private GraphQLCodegenFileCreator() {
    }

    static File generateFile(Template template, Map<String, Object> dataModel, File outputDir) {
        String fileName = dataModel.get("className") + EXTENSION;
        File fileOutputDir = GraphQLCodegenFileCreator.getFileTargetDirectory(dataModel, outputDir);
        File javaSourceFile = new File(fileOutputDir, fileName);
        try {
            if (!javaSourceFile.createNewFile()) {
                throw new FileAlreadyExistsException("File already exists: " + javaSourceFile.getPath());
            }
            template.process(dataModel, (Writer)new FileWriter(javaSourceFile));
        }
        catch (Exception e) {
            throw new UnableToCreateFileException(e);
        }
        return javaSourceFile;
    }

    static void prepareOutputDir(File outputDir) {
        Utils.deleteDir(outputDir);
        Utils.createDirIfAbsent(outputDir);
    }

    private static File getFileTargetDirectory(Map<String, Object> dataModel, File outputDir) {
        Object packageName = dataModel.get("package");
        File targetDir = packageName != null && Utils.isNotBlank(packageName.toString()) ? new File(outputDir, packageName.toString().replace(".", File.separator)) : outputDir;
        Utils.createDirIfAbsent(targetDir);
        return targetDir;
    }
}

