/*
 * Decompiled with CFR 0.152.
 */
package org.jmotor.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorLookup$ {
    public static ExecutorLookup$ MODULE$;
    private Config _config;

    static {
        new ExecutorLookup$();
    }

    public void setup(Config config) {
        this._config = config;
    }

    public Config config() {
        if (Objects.isNull(this._config)) {
            throw new IllegalStateException("Using org.jmotor.concurrent.ExecutorLookup.setup(config) to init");
        }
        return this._config;
    }

    public Executor lookup(String name) {
        Config dispatchConfig = this.config().getConfig(name);
        String executor = dispatchConfig.getString("executor");
        String string = executor;
        if (!"thread-pool-executor".equals(string)) {
            throw new UnsupportedOperationException();
        }
        int max = dispatchConfig.getInt(new StringBuilder(19).append(executor).append(".core-pool-size-max").toString());
        int min = dispatchConfig.getInt(new StringBuilder(19).append(executor).append(".core-pool-size-min").toString());
        int factor = dispatchConfig.getInt(new StringBuilder(22).append(executor).append(".core-pool-size-factor").toString());
        int desired = Runtime.getRuntime().availableProcessors() * factor;
        int core = Math.max(Math.min(max, desired), min);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat(new StringBuilder(3).append(name).append("-%d").toString()).build();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(core, max, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), tf);
        return threadPoolExecutor;
    }

    private ExecutorLookup$() {
        MODULE$ = this;
    }
}

