/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.URLUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class URLDecodingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final String charset;

    public URLDecodingHandler(HttpHandler next, String charset) {
        this.next = next;
        this.charset = charset;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean decodeDone = exchange.getConnection().getUndertowOptions().get(UndertowOptions.DECODE_URL, true);
        if (!decodeDone) {
            StringBuilder sb = new StringBuilder();
            boolean decodeSlash = exchange.getConnection().getUndertowOptions().get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
            exchange.setRequestPath(URLUtils.decode(exchange.getRequestPath(), this.charset, decodeSlash, false, sb));
            exchange.setRelativePath(URLUtils.decode(exchange.getRelativePath(), this.charset, decodeSlash, false, sb));
            exchange.setResolvedPath(URLUtils.decode(exchange.getResolvedPath(), this.charset, decodeSlash, false, sb));
            if (!exchange.getQueryString().isEmpty()) {
                Map<String, String> parameters;
                TreeMap newParams = new TreeMap();
                for (Map.Entry<String, Deque<String>> param : exchange.getQueryParameters().entrySet()) {
                    ArrayDeque<String> newVales = new ArrayDeque<String>(param.getValue().size());
                    for (String val : param.getValue()) {
                        newVales.add(URLUtils.decode(val, this.charset, true, true, sb));
                    }
                    newParams.put(URLUtils.decode(param.getKey(), this.charset, true, true, sb), newVales);
                }
                exchange.getQueryParameters().clear();
                exchange.getQueryParameters().putAll(newParams);
                PathTemplateMatch pathTemplateMatch = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
                if (pathTemplateMatch != null && (parameters = pathTemplateMatch.getParameters()) != null) {
                    for (Map.Entry<String, String> entry : parameters.entrySet()) {
                        entry.setValue(URLUtils.decode(entry.getValue(), this.charset, true, true, sb));
                    }
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String charset;

        private Wrapper(String charset) {
            this.charset = charset;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new URLDecodingHandler(handler, this.charset);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "url-decoding";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("charset", String.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("charset");
        }

        @Override
        public String defaultParameter() {
            return "charset";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper(config.get("charset").toString());
        }
    }
}

