/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.kv.Operation;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import com.orbitz.consul.util.Base64EncodingSerializer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableOperation
extends Operation {
    private final String verb;
    @Nullable
    private final String key;
    @Nullable
    private final String value;
    @Nullable
    private final Long flags;
    @Nullable
    private final BigInteger index;
    @Nullable
    private final String session;

    private ImmutableOperation(String verb, @Nullable String key, @Nullable String value, @Nullable Long flags, @Nullable BigInteger index, @Nullable String session) {
        this.verb = verb;
        this.key = key;
        this.value = value;
        this.flags = flags;
        this.index = index;
        this.session = session;
    }

    @Override
    @JsonProperty(value="Verb")
    public String verb() {
        return this.verb;
    }

    @Override
    @JsonProperty(value="Key")
    public Optional<String> key() {
        return Optional.ofNullable(this.key);
    }

    @Override
    @JsonProperty(value="Value")
    @JsonSerialize(using=Base64EncodingSerializer.class)
    @JsonDeserialize(using=Base64EncodingDeserializer.class)
    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<Long> flags() {
        return Optional.ofNullable(this.flags);
    }

    @Override
    @JsonProperty(value="Index")
    public Optional<BigInteger> index() {
        return Optional.ofNullable(this.index);
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> session() {
        return Optional.ofNullable(this.session);
    }

    public final ImmutableOperation withVerb(String value) {
        if (this.verb.equals(value)) {
            return this;
        }
        return new ImmutableOperation((String)Preconditions.checkNotNull((Object)value, (Object)"verb"), this.key, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withKey(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        if (Objects.equals(this.key, newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, newValue, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.key, value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, value, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withValue(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, newValue, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withFlags(long value) {
        Long newValue = value;
        if (Objects.equals(this.flags, newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, newValue, this.index, this.session);
    }

    public final ImmutableOperation withFlags(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.flags, value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, value, this.index, this.session);
    }

    public final ImmutableOperation withIndex(BigInteger value) {
        BigInteger newValue = (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"index");
        if (this.index == newValue) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, newValue, this.session);
    }

    public final ImmutableOperation withIndex(Optional<BigInteger> optional) {
        BigInteger value = optional.orElse(null);
        if (this.index == value) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, value, this.session);
    }

    public final ImmutableOperation withSession(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"session");
        if (Objects.equals(this.session, newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, newValue);
    }

    public final ImmutableOperation withSession(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.session, value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperation && this.equalTo((ImmutableOperation)another);
    }

    private boolean equalTo(ImmutableOperation another) {
        return this.verb.equals(another.verb) && Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value) && Objects.equals(this.flags, another.flags) && Objects.equals(this.index, another.index) && Objects.equals(this.session, another.session);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.verb.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.key});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.value});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.flags});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.index});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.session});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Operation").omitNullValues().add("verb", (Object)this.verb).add("key", (Object)this.key).add("value", (Object)this.value).add("flags", (Object)this.flags).add("index", (Object)this.index).add("session", (Object)this.session).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableOperation fromJson(Json json) {
        Builder builder = ImmutableOperation.builder();
        if (json.verb != null) {
            builder.verb(json.verb);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        return builder.build();
    }

    public static ImmutableOperation copyOf(Operation instance) {
        if (instance instanceof ImmutableOperation) {
            return (ImmutableOperation)instance;
        }
        return ImmutableOperation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERB = 1L;
        private long initBits = 1L;
        @Nullable
        private String verb;
        @Nullable
        private String key;
        @Nullable
        private String value;
        @Nullable
        private Long flags;
        @Nullable
        private BigInteger index;
        @Nullable
        private String session;

        private Builder() {
        }

        public final Builder from(Operation instance) {
            Optional<String> sessionOptional;
            Optional<BigInteger> indexOptional;
            Optional<Long> flagsOptional;
            Optional<String> valueOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.verb(instance.verb());
            Optional<String> keyOptional = instance.key();
            if (keyOptional.isPresent()) {
                this.key(keyOptional);
            }
            if ((valueOptional = instance.value()).isPresent()) {
                this.value(valueOptional);
            }
            if ((flagsOptional = instance.flags()).isPresent()) {
                this.flags(flagsOptional);
            }
            if ((indexOptional = instance.index()).isPresent()) {
                this.index(indexOptional);
            }
            if ((sessionOptional = instance.session()).isPresent()) {
                this.session(sessionOptional);
            }
            return this;
        }

        public final Builder verb(String verb) {
            this.verb = (String)Preconditions.checkNotNull((Object)verb, (Object)"verb");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            return this;
        }

        public final Builder key(Optional<String> key) {
            this.key = key.orElse(null);
            return this;
        }

        public final Builder value(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public final Builder value(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder flags(long flags) {
            this.flags = flags;
            return this;
        }

        public final Builder flags(Optional<Long> flags) {
            this.flags = flags.orElse(null);
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = (BigInteger)Preconditions.checkNotNull((Object)index, (Object)"index");
            return this;
        }

        public final Builder index(Optional<BigInteger> index) {
            this.index = index.orElse(null);
            return this;
        }

        public final Builder session(String session) {
            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"session");
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = session.orElse(null);
            return this;
        }

        public ImmutableOperation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, this.session);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("verb");
            }
            return "Cannot build Operation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Operation {
        @Nullable
        String verb;
        Optional<String> key = Optional.empty();
        Optional<String> value = Optional.empty();
        Optional<Long> flags = Optional.empty();
        Optional<BigInteger> index = Optional.empty();
        Optional<String> session = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Verb")
        public void setVerb(String verb) {
            this.verb = verb;
        }

        @JsonProperty(value="Key")
        public void setKey(Optional<String> key) {
            this.key = key;
        }

        @JsonProperty(value="Value")
        @JsonSerialize(using=Base64EncodingSerializer.class)
        @JsonDeserialize(using=Base64EncodingDeserializer.class)
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<Long> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Index")
        public void setIndex(Optional<BigInteger> index) {
            this.index = index;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @Override
        public String verb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigInteger> index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> session() {
            throw new UnsupportedOperationException();
        }
    }
}

