/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Telemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTelemetry
extends Telemetry {
    private final String statsiteAddr;
    private final String statsdAddr;
    private final String statsitePrefix;
    private final Boolean disableHostname;
    private final String dogStatsdAddr;
    @Nullable
    private final List<String> dogStatsdTags;

    private ImmutableTelemetry(String statsiteAddr, String statsdAddr, String statsitePrefix, Boolean disableHostname, String dogStatsdAddr, @Nullable List<String> dogStatsdTags) {
        this.statsiteAddr = statsiteAddr;
        this.statsdAddr = statsdAddr;
        this.statsitePrefix = statsitePrefix;
        this.disableHostname = disableHostname;
        this.dogStatsdAddr = dogStatsdAddr;
        this.dogStatsdTags = dogStatsdTags;
    }

    @Override
    @JsonProperty(value="StatsiteAddr")
    public String getStatsiteAddr() {
        return this.statsiteAddr;
    }

    @Override
    @JsonProperty(value="StatsdAddr")
    public String getStatsdAddr() {
        return this.statsdAddr;
    }

    @Override
    @JsonProperty(value="StatsitePrefix")
    public String getStatsitePrefix() {
        return this.statsitePrefix;
    }

    @Override
    @JsonProperty(value="DisableHostname")
    public Boolean getDisableHostname() {
        return this.disableHostname;
    }

    @Override
    @JsonProperty(value="DogStatsdAddr")
    public String getDogStatsdAddr() {
        return this.dogStatsdAddr;
    }

    @Override
    @JsonProperty(value="DogStatsdTags")
    public Optional<List<String>> getDogStatsdTags() {
        return Optional.ofNullable(this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsiteAddr(String value) {
        if (this.statsiteAddr.equals(value)) {
            return this;
        }
        return new ImmutableTelemetry((String)Preconditions.checkNotNull((Object)value, (Object)"statsiteAddr"), this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsdAddr(String value) {
        if (this.statsdAddr.equals(value)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, (String)Preconditions.checkNotNull((Object)value, (Object)"statsdAddr"), this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withStatsitePrefix(String value) {
        if (this.statsitePrefix.equals(value)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, (String)Preconditions.checkNotNull((Object)value, (Object)"statsitePrefix"), this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDisableHostname(Boolean value) {
        if (this.disableHostname.equals(value)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, (Boolean)Preconditions.checkNotNull((Object)value, (Object)"disableHostname"), this.dogStatsdAddr, this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDogStatsdAddr(String value) {
        if (this.dogStatsdAddr.equals(value)) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, (String)Preconditions.checkNotNull((Object)value, (Object)"dogStatsdAddr"), this.dogStatsdTags);
    }

    public final ImmutableTelemetry withDogStatsdTags(List<String> value) {
        List newValue = (List)Preconditions.checkNotNull(value, (Object)"dogStatsdTags");
        if (this.dogStatsdTags == newValue) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, newValue);
    }

    public final ImmutableTelemetry withDogStatsdTags(Optional<List<String>> optional) {
        List value = optional.orElse(null);
        if (this.dogStatsdTags == value) {
            return this;
        }
        return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTelemetry && this.equalTo((ImmutableTelemetry)another);
    }

    private boolean equalTo(ImmutableTelemetry another) {
        return this.statsiteAddr.equals(another.statsiteAddr) && this.statsdAddr.equals(another.statsdAddr) && this.statsitePrefix.equals(another.statsitePrefix) && this.disableHostname.equals(another.disableHostname) && this.dogStatsdAddr.equals(another.dogStatsdAddr) && Objects.equals(this.dogStatsdTags, another.dogStatsdTags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.statsiteAddr.hashCode();
        h = h * 17 + this.statsdAddr.hashCode();
        h = h * 17 + this.statsitePrefix.hashCode();
        h = h * 17 + this.disableHostname.hashCode();
        h = h * 17 + this.dogStatsdAddr.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.dogStatsdTags});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Telemetry").omitNullValues().add("statsiteAddr", (Object)this.statsiteAddr).add("statsdAddr", (Object)this.statsdAddr).add("statsitePrefix", (Object)this.statsitePrefix).add("disableHostname", (Object)this.disableHostname).add("dogStatsdAddr", (Object)this.dogStatsdAddr).add("dogStatsdTags", this.dogStatsdTags).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTelemetry fromJson(Json json) {
        Builder builder = ImmutableTelemetry.builder();
        if (json.statsiteAddr != null) {
            builder.statsiteAddr(json.statsiteAddr);
        }
        if (json.statsdAddr != null) {
            builder.statsdAddr(json.statsdAddr);
        }
        if (json.statsitePrefix != null) {
            builder.statsitePrefix(json.statsitePrefix);
        }
        if (json.disableHostname != null) {
            builder.disableHostname(json.disableHostname);
        }
        if (json.dogStatsdAddr != null) {
            builder.dogStatsdAddr(json.dogStatsdAddr);
        }
        if (json.dogStatsdTags != null) {
            builder.dogStatsdTags(json.dogStatsdTags);
        }
        return builder.build();
    }

    public static ImmutableTelemetry copyOf(Telemetry instance) {
        if (instance instanceof ImmutableTelemetry) {
            return (ImmutableTelemetry)instance;
        }
        return ImmutableTelemetry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATSITE_ADDR = 1L;
        private static final long INIT_BIT_STATSD_ADDR = 2L;
        private static final long INIT_BIT_STATSITE_PREFIX = 4L;
        private static final long INIT_BIT_DISABLE_HOSTNAME = 8L;
        private static final long INIT_BIT_DOG_STATSD_ADDR = 16L;
        private long initBits = 31L;
        @Nullable
        private String statsiteAddr;
        @Nullable
        private String statsdAddr;
        @Nullable
        private String statsitePrefix;
        @Nullable
        private Boolean disableHostname;
        @Nullable
        private String dogStatsdAddr;
        @Nullable
        private List<String> dogStatsdTags;

        private Builder() {
        }

        public final Builder from(Telemetry instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.statsiteAddr(instance.getStatsiteAddr());
            this.statsdAddr(instance.getStatsdAddr());
            this.statsitePrefix(instance.getStatsitePrefix());
            this.disableHostname(instance.getDisableHostname());
            this.dogStatsdAddr(instance.getDogStatsdAddr());
            Optional<List<String>> dogStatsdTagsOptional = instance.getDogStatsdTags();
            if (dogStatsdTagsOptional.isPresent()) {
                this.dogStatsdTags(dogStatsdTagsOptional);
            }
            return this;
        }

        public final Builder statsiteAddr(String statsiteAddr) {
            this.statsiteAddr = (String)Preconditions.checkNotNull((Object)statsiteAddr, (Object)"statsiteAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder statsdAddr(String statsdAddr) {
            this.statsdAddr = (String)Preconditions.checkNotNull((Object)statsdAddr, (Object)"statsdAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder statsitePrefix(String statsitePrefix) {
            this.statsitePrefix = (String)Preconditions.checkNotNull((Object)statsitePrefix, (Object)"statsitePrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder disableHostname(Boolean disableHostname) {
            this.disableHostname = (Boolean)Preconditions.checkNotNull((Object)disableHostname, (Object)"disableHostname");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder dogStatsdAddr(String dogStatsdAddr) {
            this.dogStatsdAddr = (String)Preconditions.checkNotNull((Object)dogStatsdAddr, (Object)"dogStatsdAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder dogStatsdTags(List<String> dogStatsdTags) {
            this.dogStatsdTags = (List)Preconditions.checkNotNull(dogStatsdTags, (Object)"dogStatsdTags");
            return this;
        }

        public final Builder dogStatsdTags(Optional<List<String>> dogStatsdTags) {
            this.dogStatsdTags = dogStatsdTags.orElse(null);
            return this;
        }

        public ImmutableTelemetry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTelemetry(this.statsiteAddr, this.statsdAddr, this.statsitePrefix, this.disableHostname, this.dogStatsdAddr, this.dogStatsdTags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("statsiteAddr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("statsdAddr");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("statsitePrefix");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("disableHostname");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dogStatsdAddr");
            }
            return "Cannot build Telemetry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Telemetry {
        @Nullable
        String statsiteAddr;
        @Nullable
        String statsdAddr;
        @Nullable
        String statsitePrefix;
        @Nullable
        Boolean disableHostname;
        @Nullable
        String dogStatsdAddr;
        Optional<List<String>> dogStatsdTags = Optional.empty();

        Json() {
        }

        @JsonProperty(value="StatsiteAddr")
        public void setStatsiteAddr(String statsiteAddr) {
            this.statsiteAddr = statsiteAddr;
        }

        @JsonProperty(value="StatsdAddr")
        public void setStatsdAddr(String statsdAddr) {
            this.statsdAddr = statsdAddr;
        }

        @JsonProperty(value="StatsitePrefix")
        public void setStatsitePrefix(String statsitePrefix) {
            this.statsitePrefix = statsitePrefix;
        }

        @JsonProperty(value="DisableHostname")
        public void setDisableHostname(Boolean disableHostname) {
            this.disableHostname = disableHostname;
        }

        @JsonProperty(value="DogStatsdAddr")
        public void setDogStatsdAddr(String dogStatsdAddr) {
            this.dogStatsdAddr = dogStatsdAddr;
        }

        @JsonProperty(value="DogStatsdTags")
        public void setDogStatsdTags(Optional<List<String>> dogStatsdTags) {
            this.dogStatsdTags = dogStatsdTags;
        }

        @Override
        public String getStatsiteAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatsdAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatsitePrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDisableHostname() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDogStatsdAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getDogStatsdTags() {
            throw new UnsupportedOperationException();
        }
    }
}

