/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.acl.AclTokenId;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableAclTokenId
extends AclTokenId {
    private final String id;

    private ImmutableAclTokenId(String id) {
        this.id = id;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    public final ImmutableAclTokenId withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableAclTokenId((String)Preconditions.checkNotNull((Object)value, (Object)"id"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAclTokenId && this.equalTo((ImmutableAclTokenId)another);
    }

    private boolean equalTo(ImmutableAclTokenId another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AclTokenId").omitNullValues().add("id", (Object)this.id).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableAclTokenId fromJson(Json json) {
        Builder builder = ImmutableAclTokenId.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableAclTokenId copyOf(AclTokenId instance) {
        if (instance instanceof ImmutableAclTokenId) {
            return (ImmutableAclTokenId)instance;
        }
        return ImmutableAclTokenId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;

        private Builder() {
        }

        public final Builder from(AclTokenId instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.id());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAclTokenId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAclTokenId(this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build AclTokenId, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends AclTokenId {
        @Nullable
        String id;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }
    }
}

