/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.BaseClient;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.NotRegisteredException;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.agent.Agent;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.agent.ImmutableCheck;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Member;
import com.orbitz.consul.model.agent.Registration;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.monitoring.ClientEventCallback;
import com.orbitz.consul.option.QueryOptions;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class AgentClient
extends BaseClient {
    private static String CLIENT_NAME = "agent";
    private final Api api;

    AgentClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public boolean isRegistered(String serviceId) {
        Map<String, Service> serviceIdToService = this.getServices();
        return serviceIdToService.containsKey(serviceId);
    }

    public void ping() {
        try {
            Response response = this.api.ping().execute();
            if (!response.isSuccessful()) {
                throw new ConsulException(String.format("Error pinging Consul: %s", response.message()));
            }
        }
        catch (Exception ex) {
            throw new ConsulException("Error connecting to Consul", ex);
        }
    }

    public void register(int port, long ttl, String name, String id, List<String> tags, Map<String, String> meta) {
        Registration.RegCheck check = Registration.RegCheck.ttl(ttl);
        this.register(port, check, name, id, tags, meta);
    }

    public void register(int port, String args, long interval, String name, String id, List<String> tags, Map<String, String> meta) {
        Registration.RegCheck check = Registration.RegCheck.args(Collections.singletonList(args), interval);
        this.register(port, check, name, id, tags, meta);
    }

    public void register(int port, List<String> args, long interval, String name, String id, List<String> tags, Map<String, String> meta) {
        Registration.RegCheck check = Registration.RegCheck.args(args, interval);
        this.register(port, check, name, id, tags, meta);
    }

    public void register(int port, URL http, long interval, String name, String id, List<String> tags, Map<String, String> meta) {
        Registration.RegCheck check = Registration.RegCheck.http(http.toExternalForm(), interval);
        this.register(port, check, name, id, tags, meta);
    }

    public void register(int port, HostAndPort tcp, long interval, String name, String id, List<String> tags, Map<String, String> meta) {
        Registration.RegCheck check = Registration.RegCheck.tcp(tcp.toString(), interval);
        this.register(port, check, name, id, tags, meta);
    }

    public void register(int port, Registration.RegCheck check, String name, String id, List<String> tags, Map<String, String> meta) {
        ImmutableRegistration registration = ImmutableRegistration.builder().port(port).check(Optional.ofNullable(check)).name(name).id(id).tags(tags).meta(meta).build();
        this.register(registration);
    }

    public void register(int port, List<Registration.RegCheck> checks, String name, String id, List<String> tags, Map<String, String> meta) {
        ImmutableRegistration registration = ImmutableRegistration.builder().port(port).checks(checks).name(name).id(id).tags(tags).meta(meta).build();
        this.register(registration);
    }

    public void register(Registration registration, QueryOptions options) {
        this.http.handle(this.api.register(registration, options.toQuery()), new Integer[0]);
    }

    public void register(Registration registration) {
        this.register(registration, QueryOptions.BLANK);
    }

    public void deregister(String serviceId, QueryOptions options) {
        this.http.handle(this.api.deregister(serviceId, options.toQuery()), new Integer[0]);
    }

    public void deregister(String serviceId) {
        this.deregister(serviceId, QueryOptions.BLANK);
    }

    public void registerCheck(String checkId, String name, String script, long interval) {
        this.registerCheck(checkId, name, script, interval, null);
    }

    public void registerCheck(String checkId, String name, URL http, long interval) {
        this.registerCheck(checkId, name, http, interval, null);
    }

    public void registerCheck(String checkId, String name, HostAndPort tcp, long interval) {
        this.registerCheck(checkId, name, tcp, interval, null);
    }

    public void registerCheck(String checkId, String name, List<String> args, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).args(args).interval(String.format("%ss", interval)).notes(Optional.ofNullable(notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, String args, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).args(Collections.singletonList(args)).interval(String.format("%ss", interval)).notes(Optional.ofNullable(notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, URL http, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).http(http.toExternalForm()).interval(String.format("%ss", interval)).notes(Optional.ofNullable(notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, HostAndPort tcp, long interval, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).tcp(tcp.toString()).interval(String.format("%ss", interval)).notes(Optional.ofNullable(notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, long ttl) {
        this.registerCheck(checkId, name, ttl, null);
    }

    public void registerCheck(String checkId, String name, long ttl, String notes) {
        ImmutableCheck check = ImmutableCheck.builder().id(checkId).name(name).ttl(String.format("%ss", ttl)).notes(Optional.ofNullable(notes)).build();
        this.registerCheck(check);
    }

    public void registerCheck(Check check) {
        this.http.handle(this.api.registerCheck(check), new Integer[0]);
    }

    public void deregisterCheck(String checkId) {
        this.http.handle(this.api.deregisterCheck(checkId), new Integer[0]);
    }

    public Agent getAgent() {
        return this.http.extract(this.api.getAgent(), new Integer[0]);
    }

    public Map<String, HealthCheck> getChecks() {
        return this.http.extract(this.api.getChecks(), new Integer[0]);
    }

    public Map<String, Service> getServices() {
        return this.http.extract(this.api.getServices(), new Integer[0]);
    }

    public List<Member> getMembers() {
        return this.http.extract(this.api.getMembers(), new Integer[0]);
    }

    public void forceLeave(String node) {
        this.http.handle(this.api.forceLeave(node), new Integer[0]);
    }

    public void check(String checkId, State state, String note) throws NotRegisteredException {
        try {
            ImmutableMap query = note == null ? Collections.emptyMap() : ImmutableMap.of((Object)"note", (Object)note);
            this.http.handle(this.api.check(state.getPath(), checkId, (Map<String, String>)query), new Integer[0]);
        }
        catch (Exception ex) {
            throw new NotRegisteredException("Error checking state", ex);
        }
    }

    public void checkTtl(String serviceId, State state, String note) throws NotRegisteredException {
        this.check("service:" + serviceId, state, note);
    }

    public void pass(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, null);
    }

    public void pass(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, note);
    }

    public void warn(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, null);
    }

    public void warn(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, note);
    }

    public void fail(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, null);
    }

    public void fail(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, note);
    }

    public void passCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.PASS, null);
    }

    public void passCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.PASS, note);
    }

    public void warnCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.WARN, null);
    }

    public void warnCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.WARN, note);
    }

    public void failCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.FAIL, null);
    }

    public void failCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.FAIL, note);
    }

    public boolean join(String address) {
        return this.join(address, false);
    }

    public boolean join(String address, boolean wan) {
        ImmutableMap query = wan ? ImmutableMap.of((Object)"wan", (Object)"1") : Collections.emptyMap();
        boolean result = true;
        try {
            this.http.handle(this.api.join(address, (Map<String, String>)query), new Integer[0]);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public void toggleMaintenanceMode(String serviceId, boolean enable) {
        this.http.handle(this.api.toggleMaintenanceMode(serviceId, (Map<String, String>)ImmutableMap.of((Object)"enable", (Object)Boolean.toString(enable))), new Integer[0]);
    }

    public void toggleMaintenanceMode(String serviceId, boolean enable, String reason) {
        this.http.handle(this.api.toggleMaintenanceMode(serviceId, (Map<String, String>)ImmutableMap.of((Object)"enable", (Object)Boolean.toString(enable), (Object)"reason", (Object)reason)), new Integer[0]);
    }

    static interface Api {
        @PUT(value="agent/service/register")
        public Call<Void> register(@Body Registration var1, @QueryMap Map<String, Object> var2);

        @PUT(value="agent/service/deregister/{serviceId}")
        public Call<Void> deregister(@Path(value="serviceId") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="agent/check/register")
        public Call<Void> registerCheck(@Body Check var1);

        @PUT(value="agent/check/deregister/{checkId}")
        public Call<Void> deregisterCheck(@Path(value="checkId") String var1);

        @GET(value="agent/self")
        public Call<Void> ping();

        @GET(value="agent/self")
        public Call<Agent> getAgent();

        @GET(value="agent/checks")
        public Call<Map<String, HealthCheck>> getChecks();

        @GET(value="agent/services")
        public Call<Map<String, Service>> getServices();

        @GET(value="agent/members")
        public Call<List<Member>> getMembers();

        @PUT(value="agent/force-leave/{node}")
        public Call<Void> forceLeave(@Path(value="string") String var1);

        @PUT(value="agent/check/{state}/{checkId}")
        public Call<Void> check(@Path(value="state") String var1, @Path(value="checkId") String var2, @QueryMap Map<String, String> var3);

        @PUT(value="agent/join/{address}")
        public Call<Void> join(@Path(value="address") String var1, @QueryMap Map<String, String> var2);

        @PUT(value="agent/service/maintenance/{serviceId}")
        public Call<Void> toggleMaintenanceMode(@Path(value="serviceId") String var1, @QueryMap Map<String, String> var2);
    }
}

