/*
 * Decompiled with CFR 0.152.
 */
package org.jmotor.undertow.logger;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jmotor.undertow.logger.AccessLogHandler$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001-\u0011\u0001#Q2dKN\u001cHj\\4IC:$G.\u001a:\u000b\u0005\r!\u0011A\u00027pO\u001e,'O\u0003\u0002\u0006\r\u0005AQO\u001c3feR|wO\u0003\u0002\b\u0011\u00051!.\\8u_JT\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012AB:feZ,'O\u0003\u0002\u00063)\t!$\u0001\u0002j_&\u0011AD\u0006\u0002\f\u0011R$\b\u000fS1oI2,'\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0011qW\r\u001f;\t\u0011\u0001\u0002!\u0011!Q\u0001\n\u0005\nqa]3sm&\u001cW\rE\u0002#K\u001dj\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005!zcBA\u0015.!\tQ3%D\u0001,\u0015\ta#\"\u0001\u0004=e>|GOP\u0005\u0003]\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011af\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U:\u0004\b\u0005\u00027\u00015\t!\u0001C\u0003\u001fe\u0001\u0007A\u0003C\u0004!eA\u0005\t\u0019A\u0011\t\r\r\u0001\u0001\u0015!\u0003;!\tY$)D\u0001=\u0015\tid(A\u0003m_\u001e$$N\u0003\u0002@\u0001\u00069An\\4hS:<'BA!\t\u0003\u0019\t\u0007/Y2iK&\u00111\t\u0010\u0002\u0007\u0019><w-\u001a:\t\r\u0015\u0003\u0001\u0015!\u0003G\u0003!a\u0017n\u001d;f]\u0016\u0014\bCA\u000bH\u0013\tAeC\u0001\u000eFq\u000eD\u0017M\\4f\u0007>l\u0007\u000f\\3uS>tG*[:uK:,'\u000fC\u0003K\u0001\u0011\u00053*A\u0007iC:$G.\u001a*fcV,7\u000f\u001e\u000b\u0003\u0019>\u0003\"AI'\n\u00059\u001b#\u0001B+oSRDQ\u0001U%A\u0002E\u000b\u0001\"\u001a=dQ\u0006tw-\u001a\t\u0003+IK!a\u0015\f\u0003%!#H\u000f]*feZ,'/\u0012=dQ\u0006tw-\u001a\u0005\u0007+\u0002\u0001K\u0011\u0002,\u0002\u0019\u001d,GOU3rk\u0016\u001cH/\u00133\u0015\u0005\u001d:\u0006\"\u0002)U\u0001\u0004\t\u0006BB-\u0001A\u0013%!,\u0001\tbG\u000e,7o\u001d'pO6+7o]1hKR\u0019qeW/\t\u000bqC\u0006\u0019A\u0014\u0002\u0013I,\u0017/^3ti&#\u0007\"\u0002)Y\u0001\u0004\t\u0006BB0\u0001A\u0013%\u0001-A\u0004jg\u0016k\u0007\u000f^=\u0015\u0005\u0005$\u0007C\u0001\u0012c\u0013\t\u00197EA\u0004C_>dW-\u00198\t\u000b\u0015t\u0006\u0019\u00014\u0002\rY\fG.^3t!\t9'.D\u0001i\u0015\tI\u0007$\u0001\u0003vi&d\u0017BA6i\u00051AU-\u00193feZ\u000bG.^3t\u000f\u001di'!!A\t\u00029\f\u0001#Q2dKN\u001cHj\\4IC:$G.\u001a:\u0011\u0005YzgaB\u0001\u0003\u0003\u0003E\t\u0001]\n\u0003_F\u0004\"A\t:\n\u0005M\u001c#AB!osJ+g\rC\u00034_\u0012\u0005Q\u000fF\u0001o\u0011\u001d9x.%A\u0005\u0002a\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T#A=+\u0005\u0005R8&A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011A\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0006u\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AccessLogHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Option<String> service;
    private final Logger logger;
    private final ExchangeCompletionListener listener;

    public static Option<String> $lessinit$greater$default$2() {
        return AccessLogHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public void handleRequest(HttpServerExchange exchange) {
        exchange.addExchangeCompleteListener(this.listener);
        this.next.handleRequest(exchange);
    }

    private String getRequestId(HttpServerExchange exchange) {
        HeaderValues requestId = exchange.getRequestHeaders().get("X-Request-Id");
        return this.isEmpty(requestId) ? RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(UUID.randomUUID().getLeastSignificantBits())) : requestId.getFirst();
    }

    private String accessLogMessage(String requestId, HttpServerExchange exchange) {
        double cost = (double)(System.nanoTime() - exchange.getRequestStartTime()) / 1000000.0;
        String path = exchange.getRequestPath();
        int status = exchange.getStatusCode();
        HeaderMap headers = exchange.getRequestHeaders();
        String protocol = exchange.getProtocol().toString();
        long bytesSent = exchange.getResponseBytesSent();
        String method = exchange.getRequestMethod().toString();
        HeaderValues referer = headers.get("Referer");
        String ua = headers.getFirst("User-Agent");
        String now = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String referred = this.isEmpty(referer) ? "-" : referer.getFirst();
        String sn = (String)this.service.getOrElse((Function0 & java.io.Serializable & Serializable)() -> "-");
        String address = exchange.getSourceAddress().getAddress().getHostAddress();
        return new StringBuilder(21).append(address).append(" ").append(sn).append(" ").append(requestId).append(" - [").append(now).append("] \"").append(method).append(" ").append(path).append(" ").append(protocol).append("\" ").append(status).append(" ").append(bytesSent).append(" ").append(cost).append(" \"").append(referred).append("\" \"").append(ua).append("\"").toString();
    }

    private boolean isEmpty(HeaderValues values) {
        return Objects.isNull(values) || values.isEmpty();
    }

    public AccessLogHandler(HttpHandler next, Option<String> service) {
        this.next = next;
        this.service = service;
        this.logger = LogManager.getLogger((String)"access");
        this.listener = (exchange, nextListener) -> {
            try {
                String requestId = this.getRequestId(exchange);
                if ($this.logger.isInfoEnabled()) {
                    $this.logger.info(this.accessLogMessage(requestId, exchange));
                }
            }
            finally {
                nextListener.proceed();
            }
        };
    }
}

