/*
 * Decompiled with CFR 0.152.
 */
package io.growing.dryad.git2consul.sync.impl;

import com.google.common.hash.Hashing;
import io.growing.dryad.git2consul.cache.Caches$;
import io.growing.dryad.git2consul.config.Git2ConsulConfig;
import io.growing.dryad.git2consul.sync.ConfigurationSyncer;
import io.growing.dryad.git2consul.utils.Configuration;
import io.growing.dryad.git2consul.utils.Configurations$;
import io.growing.dryad.git2consul.writer.ConfigurationWriter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.eclipse.jgit.api.Git;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Unit$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3Aa\u0002\u0005\u0001+!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0019\u0001\u0005\u0001)A\u0005\u0003\")1\u0002\u0001C!\u0013\"1Q\n\u0001C\u0001\u00119\u0013acR5u\u0007>tg-[4ve\u0006$\u0018n\u001c8Ts:\u001cWM\u001d\u0006\u0003\u0013)\tA![7qY*\u00111\u0002D\u0001\u0005gft7M\u0003\u0002\u000e\u001d\u0005Qq-\u001b;3G>t7/\u001e7\u000b\u0005=\u0001\u0012!\u00023ss\u0006$'BA\t\u0013\u0003\u001d9'o\\<j]\u001eT\u0011aE\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001-q\u0001\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\t!\"\u0003\u0002 \u0015\t\u00192i\u001c8gS\u001e,(/\u0019;j_:\u001c\u0016P\\2feB\u0011\u0011eK\u0007\u0002E)\u0011\u0011d\t\u0006\u0003I\u0015\nQ\u0001\\8hi)T!AJ\u0014\u0002\u000f1|wmZ5oO*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta#EA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\ty\u0013'D\u00011\u0015\tiC\"\u0003\u00023a\t\u0001r)\u001b;3\u0007>t7/\u001e7D_:4\u0017nZ\u0001\u0014G>tg-[4ve\u0006$\u0018n\u001c8Xe&$XM\u001d\t\u0003kaj\u0011A\u000e\u0006\u0003o1\taa\u001e:ji\u0016\u0014\u0018BA\u001d7\u0005M\u0019uN\u001c4jOV\u0014\u0018\r^5p]^\u0013\u0018\u000e^3s\u0003\u0019a\u0014N\\5u}Q\u0019AHP \u0011\u0005u\u0002Q\"\u0001\u0005\t\u000b5\u001a\u0001\u0019\u0001\u0018\t\u000bM\u001a\u0001\u0019\u0001\u001b\u0002\u0019]\u0014\u0018\u000e^3US6,w.\u001e;\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\u0019C\u0012AC2p]\u000e,(O]3oi&\u0011\u0001j\u0011\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o)\u0005Q\u0005CA\fL\u0013\ta\u0005D\u0001\u0003V]&$\u0018A\u00023p'ft7\r\u0006\u0002K\u001f\")\u0001K\u0002a\u0001#\u0006!!o\\8u!\t\u0011\u0016,D\u0001T\u0015\t!V+\u0001\u0003gS2,'B\u0001,X\u0003\rq\u0017n\u001c\u0006\u00021\u0006!!.\u0019<b\u0013\tQ6K\u0001\u0003QCRD\u0007")
public class GitConfigurationSyncer
implements ConfigurationSyncer,
Logging {
    private final Git2ConsulConfig config;
    private final ConfigurationWriter configurationWriter;
    private final FiniteDuration writeTimeout;
    private final ExtendedLogger logger;

    public ExtendedLogger logger() {
        return this.logger;
    }

    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$1) {
        this.logger = x$1;
    }

    @Override
    public void sync() {
        Path root = Files.createTempDirectory("git2consul", new FileAttribute[0]);
        Git.cloneRepository().setDirectory(root.toFile()).setURI(this.config.git().uri()).call();
        this.doSync(root);
    }

    public void doSync(Path root) {
        Seq<Configuration> configurations = Configurations$.MODULE$.getConfigurations(root);
        Seq futures = (Seq)configurations.map((Function1 & Serializable & scala.Serializable)configuration -> {
            Future future;
            String filename = configuration.filename();
            String hash = Hashing.murmur3_128().hashBytes(com.google.common.io.Files.toByteArray((File)configuration.path().toFile())).toString();
            String version = (String)Option$.MODULE$.apply(Caches$.MODULE$.versions().get((Object)filename)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String string = hash;
            String string2 = version;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit;
                if (this.logger().isEnabled(Level.INFO)) {
                    Logger$.MODULE$.logMessage$extension1(this.logger(), Level.INFO, null, (CharSequence)new StringBuilder(19).append("file [").append(filename).append("] not changed").toString(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = Future$.MODULE$.successful((Object)Unit$.MODULE$);
            } else {
                future = $this.configurationWriter.write(configuration.path(), filename).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    GitConfigurationSyncer.$anonfun$doSync$3(this, filename, hash, BoxesRunTime.unboxToBoolean((Object)x0$1));
                    return BoxedUnit.UNIT;
                }, ExecutionContext.Implicits$.MODULE$.global());
            }
            return future;
        }, Seq$.MODULE$.canBuildFrom());
        Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.writeTimeout);
    }

    public static final /* synthetic */ void $anonfun$doSync$3(GitConfigurationSyncer $this, String filename$1, String hash$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            BoxedUnit boxedUnit;
            if ($this.logger().isEnabled(Level.INFO)) {
                Logger$.MODULE$.logMessage$extension1($this.logger(), Level.INFO, null, (CharSequence)new StringBuilder(16).append("write [").append(filename$1).append("] success").toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Caches$.MODULE$.versions().put((Object)filename$1, (Object)hash$1);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (!bl) {
            BoxedUnit boxedUnit;
            if ($this.logger().isEnabled(Level.ERROR)) {
                Logger$.MODULE$.logMessage$extension1($this.logger(), Level.ERROR, null, (CharSequence)new StringBuilder(16).append("write [").append(filename$1).append("] failure").toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
    }

    public GitConfigurationSyncer(Git2ConsulConfig config, ConfigurationWriter configurationWriter) {
        this.config = config;
        this.configurationWriter = configurationWriter;
        Logging.$init$((Logging)this);
        this.writeTimeout = new package.DurationInt(package$.MODULE$.DurationInt(1)).minutes();
    }
}

