/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Member;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableMember
extends Member {
    private final String name;
    private final String address;
    private final int port;
    private final ImmutableMap<String, String> tags;
    private final int status;
    private final int protocolMin;
    private final int protocolMax;
    private final int protocolCur;
    private final int delegateMin;
    private final int delegateMax;
    private final int delegateCur;

    private ImmutableMember(String name, String address, int port, ImmutableMap<String, String> tags, int status, int protocolMin, int protocolMax, int protocolCur, int delegateMin, int delegateMax, int delegateCur) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.tags = tags;
        this.status = status;
        this.protocolMin = protocolMin;
        this.protocolMax = protocolMax;
        this.protocolCur = protocolCur;
        this.delegateMin = delegateMin;
        this.delegateMax = delegateMax;
        this.delegateCur = delegateCur;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Addr")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableMap.class, keyAs=String.class, contentAs=String.class)
    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Status")
    public int getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="ProtocolMin")
    public int getProtocolMin() {
        return this.protocolMin;
    }

    @Override
    @JsonProperty(value="ProtocolMax")
    public int getProtocolMax() {
        return this.protocolMax;
    }

    @Override
    @JsonProperty(value="ProtocolCur")
    public int getProtocolCur() {
        return this.protocolCur;
    }

    @Override
    @JsonProperty(value="DelegateMin")
    public int getDelegateMin() {
        return this.delegateMin;
    }

    @Override
    @JsonProperty(value="DelegateMax")
    public int getDelegateMax() {
        return this.delegateMax;
    }

    @Override
    @JsonProperty(value="DelegateCur")
    public int getDelegateCur() {
        return this.delegateCur;
    }

    public final ImmutableMember withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableMember((String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableMember(this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, value, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withTags(Map<String, ? extends String> entries) {
        if (this.tags == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableMember(this.name, this.address, this.port, (ImmutableMap<String, String>)value, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, value, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolMin(int value) {
        if (this.protocolMin == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, value, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolMax(int value) {
        if (this.protocolMax == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, value, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withProtocolCur(int value) {
        if (this.protocolCur == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, value, this.delegateMin, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withDelegateMin(int value) {
        if (this.delegateMin == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, value, this.delegateMax, this.delegateCur);
    }

    public final ImmutableMember withDelegateMax(int value) {
        if (this.delegateMax == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, value, this.delegateCur);
    }

    public final ImmutableMember withDelegateCur(int value) {
        if (this.delegateCur == value) {
            return this;
        }
        return new ImmutableMember(this.name, this.address, this.port, this.tags, this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMember && this.equalTo((ImmutableMember)another);
    }

    private boolean equalTo(ImmutableMember another) {
        return this.name.equals(another.name) && this.address.equals(another.address) && this.port == another.port && this.tags.equals(another.tags) && this.status == another.status && this.protocolMin == another.protocolMin && this.protocolMax == another.protocolMax && this.protocolCur == another.protocolCur && this.delegateMin == another.delegateMin && this.delegateMax == another.delegateMax && this.delegateCur == another.delegateCur;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.port;
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + this.status;
        h = h * 17 + this.protocolMin;
        h = h * 17 + this.protocolMax;
        h = h * 17 + this.protocolCur;
        h = h * 17 + this.delegateMin;
        h = h * 17 + this.delegateMax;
        h = h * 17 + this.delegateCur;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Member").omitNullValues().add("name", (Object)this.name).add("address", (Object)this.address).add("port", this.port).add("tags", this.tags).add("status", this.status).add("protocolMin", this.protocolMin).add("protocolMax", this.protocolMax).add("protocolCur", this.protocolCur).add("delegateMin", this.delegateMin).add("delegateMax", this.delegateMax).add("delegateCur", this.delegateCur).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableMember fromJson(Json json) {
        Builder builder = ImmutableMember.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.tags != null) {
            builder.putAllTags(json.tags);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.protocolMin != null) {
            builder.protocolMin(json.protocolMin);
        }
        if (json.protocolMax != null) {
            builder.protocolMax(json.protocolMax);
        }
        if (json.protocolCur != null) {
            builder.protocolCur(json.protocolCur);
        }
        if (json.delegateMin != null) {
            builder.delegateMin(json.delegateMin);
        }
        if (json.delegateMax != null) {
            builder.delegateMax(json.delegateMax);
        }
        if (json.delegateCur != null) {
            builder.delegateCur(json.delegateCur);
        }
        return builder.build();
    }

    public static ImmutableMember copyOf(Member instance) {
        if (instance instanceof ImmutableMember) {
            return (ImmutableMember)instance;
        }
        return ImmutableMember.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private static final long INIT_BIT_PROTOCOL_MIN = 16L;
        private static final long INIT_BIT_PROTOCOL_MAX = 32L;
        private static final long INIT_BIT_PROTOCOL_CUR = 64L;
        private static final long INIT_BIT_DELEGATE_MIN = 128L;
        private static final long INIT_BIT_DELEGATE_MAX = 256L;
        private static final long INIT_BIT_DELEGATE_CUR = 512L;
        private long initBits = 1023L;
        @Nullable
        private String name;
        @Nullable
        private String address;
        private int port;
        private ImmutableMap.Builder<String, String> tagsBuilder = ImmutableMap.builder();
        private int status;
        private int protocolMin;
        private int protocolMax;
        private int protocolCur;
        private int delegateMin;
        private int delegateMax;
        private int delegateCur;

        private Builder() {
        }

        public final Builder from(Member instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            this.address(instance.getAddress());
            this.port(instance.getPort());
            this.putAllTags(instance.getTags());
            this.status(instance.getStatus());
            this.protocolMin(instance.getProtocolMin());
            this.protocolMax(instance.getProtocolMax());
            this.protocolCur(instance.getProtocolCur());
            this.delegateMin(instance.getDelegateMin());
            this.delegateMax(instance.getDelegateMax());
            this.delegateCur(instance.getDelegateCur());
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putTags(String key, String value) {
            this.tagsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putTags(Map.Entry<String, ? extends String> entry) {
            this.tagsBuilder.put(entry);
            return this;
        }

        public final Builder tags(Map<String, ? extends String> entries) {
            this.tagsBuilder = ImmutableMap.builder();
            return this.putAllTags(entries);
        }

        public final Builder putAllTags(Map<String, ? extends String> entries) {
            this.tagsBuilder.putAll(entries);
            return this;
        }

        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder protocolMin(int protocolMin) {
            this.protocolMin = protocolMin;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder protocolMax(int protocolMax) {
            this.protocolMax = protocolMax;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder protocolCur(int protocolCur) {
            this.protocolCur = protocolCur;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder delegateMin(int delegateMin) {
            this.delegateMin = delegateMin;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder delegateMax(int delegateMax) {
            this.delegateMax = delegateMax;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder delegateCur(int delegateCur) {
            this.delegateCur = delegateCur;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableMember build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMember(this.name, this.address, this.port, this.tagsBuilder.build(), this.status, this.protocolMin, this.protocolMax, this.protocolCur, this.delegateMin, this.delegateMax, this.delegateCur);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("protocolMin");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("protocolMax");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("protocolCur");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("delegateMin");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("delegateMax");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("delegateCur");
            }
            return "Cannot build Member, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Member {
        @Nullable
        String name;
        @Nullable
        String address;
        @Nullable
        Integer port;
        @Nullable
        Map<String, String> tags;
        @Nullable
        Integer status;
        @Nullable
        Integer protocolMin;
        @Nullable
        Integer protocolMax;
        @Nullable
        Integer protocolCur;
        @Nullable
        Integer delegateMin;
        @Nullable
        Integer delegateMax;
        @Nullable
        Integer delegateCur;

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Addr")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableMap.class, keyAs=String.class, contentAs=String.class)
        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Status")
        public void setStatus(int status) {
            this.status = status;
        }

        @JsonProperty(value="ProtocolMin")
        public void setProtocolMin(int protocolMin) {
            this.protocolMin = protocolMin;
        }

        @JsonProperty(value="ProtocolMax")
        public void setProtocolMax(int protocolMax) {
            this.protocolMax = protocolMax;
        }

        @JsonProperty(value="ProtocolCur")
        public void setProtocolCur(int protocolCur) {
            this.protocolCur = protocolCur;
        }

        @JsonProperty(value="DelegateMin")
        public void setDelegateMin(int delegateMin) {
            this.delegateMin = delegateMin;
        }

        @JsonProperty(value="DelegateMax")
        public void setDelegateMax(int delegateMax) {
            this.delegateMax = delegateMax;
        }

        @JsonProperty(value="DelegateCur")
        public void setDelegateCur(int delegateCur) {
            this.delegateCur = delegateCur;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProtocolCur() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDelegateCur() {
            throw new UnsupportedOperationException();
        }
    }
}

