/*
 * Decompiled with CFR 0.152.
 */
package io.growing.dryad;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.growing.dryad.ServiceProvider;
import io.growing.dryad.listener.ServiceInstanceListener;
import io.growing.dryad.portal.Schema$;
import io.growing.dryad.registry.GrpcHealthCheck;
import io.growing.dryad.registry.HealthCheck;
import io.growing.dryad.registry.HttpHealthCheck;
import io.growing.dryad.registry.ServiceRegistry;
import io.growing.dryad.registry.TTLHealthCheck;
import io.growing.dryad.registry.dto.LoadBalancing$;
import io.growing.dryad.registry.dto.Portal;
import io.growing.dryad.registry.dto.Service;
import io.growing.dryad.registry.dto.ServiceInstance;
import io.growing.dryad.util.ConfigUtils$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\t\u0012\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006[\u0001!\tA\f\u0005\tc\u0001A)\u0019)C\u0005e!I1\b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0010\u0005\t\u0003\u0002A)\u0019)C\u0005\t\")Q\n\u0001C!\u001d\")!\u000b\u0001C!\u001d\")Q\n\u0001C!'\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\t9\u0004\u0001Q\u0005\n9C\u0001\"!\u000f\u0001\t\u0003\t\u00121\b\u0005\t\u0003\u0003\u0002A\u0011A\t\u0002D!A\u0011q\t\u0001\u0005\u0002E\tIEA\nTKJ4\u0018nY3Qe>4\u0018\u000eZ3s\u00136\u0004HN\u0003\u0002\u0013'\u0005)AM]=bI*\u0011A#F\u0001\bOJ|w/\u001b8h\u0015\u00051\u0012AA5p\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002#%\u0011!%\u0005\u0002\u0010'\u0016\u0014h/[2f!J|g/\u001b3fe\u000611m\u001c8gS\u001e\u0004\"!J\u0016\u000e\u0003\u0019R!aI\u0014\u000b\u0005!J\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003)\n1aY8n\u0013\tacE\u0001\u0004D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0002\u0004C\u0001\u0011\u0001\u0011\u0015\u0019#\u00011\u0001%\u0003=9'o\\;q\u0007>tg-[4QCRDW#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\fqa]3sm&\u001cW\r\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006\u0019A\r^8\u000b\u0005\u0005\u000b\u0012\u0001\u0003:fO&\u001cHO]=\n\u0005\rs$aB*feZL7-Z\u000b\u0002\u000bB\u0011aiR\u0007\u0002\u0001&\u0011\u0001\n\u0011\u0002\u0010'\u0016\u0014h/[2f%\u0016<\u0017n\u001d;ss\"\u0012QA\u0013\t\u00035-K!\u0001T\u000e\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001B]3hSN$XM\u001d\u000b\u0002\u001fB\u0011!\u0004U\u0005\u0003#n\u0011A!\u00168ji\u0006QA-\u001a:fO&\u001cH/\u001a:\u0015\u0005=#\u0006\"B+\t\u0001\u00041\u0016\u0001\u00039biR,'O\\:\u0011\u0007i9\u0016,\u0003\u0002Y7\tQAH]3qK\u0006$X\r\u001a \u0011\tiQF\f]\u0005\u00037n\u0011a\u0001V;qY\u0016\u0014\u0004CA/n\u001d\tq&N\u0004\u0002`Q:\u0011\u0001m\u001a\b\u0003C\u001at!AY3\u000e\u0003\rT!\u0001Z\f\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002j#\u00051\u0001o\u001c:uC2L!a\u001b7\u0002\rM\u001b\u0007.Z7b\u0015\tI\u0017#\u0003\u0002o_\n11k\u00195f[\u0006T!a\u001b7\u0011\u0007E4\u0018P\u0004\u0002si:\u0011!m]\u0005\u00029%\u0011QoG\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!^\u000e\u0011\u0005ithBA>}!\t\u00117$\u0003\u0002~7\u00051\u0001K]3eK\u001aL!AO@\u000b\u0005u\\\u0012!C:vEN\u001c'/\u001b2f)\u001dy\u0015QAA\u0005\u0003\u001bAa!a\u0002\n\u0001\u0004a\u0016AB:dQ\u0016l\u0017\r\u0003\u0004\u0002\f%\u0001\r!_\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW\rC\u0004\u0002\u0010%\u0001\r!!\u0005\u0002\u00111L7\u000f^3oKJ\u0004B!a\u0005\u0002\u00185\u0011\u0011Q\u0003\u0006\u0004\u0003\u001f\t\u0012\u0002BA\r\u0003+\u0011qcU3sm&\u001cW-\u00138ti\u0006t7-\u001a'jgR,g.\u001a:\u0002\u0019\u001d,G/\u00138ti\u0006t7-Z:\u0015\u0011\u0005}\u0011qEA\u0015\u0003W\u0001B!\u001d<\u0002\"A\u0019Q(a\t\n\u0007\u0005\u0015bHA\bTKJ4\u0018nY3J]N$\u0018M\\2f\u0011\u0019\t9A\u0003a\u00019\"1\u00111\u0002\u0006A\u0002eDq!a\u0004\u000b\u0001\u0004\ti\u0003E\u0003\u001b\u0003_\t\t\"C\u0002\u00022m\u0011aa\u00149uS>t\u0017AC4fiN+'O^5dKV\tA(\u0001\u0006dQ\u0016\u001c7n\u0015;bi\u0016\f1\"\u001b8jiN+'O^5dKR\u0019q*!\u0010\t\rUk\u0001\u0019AA !\r\th/W\u0001\rEVLG\u000eZ*feZL7-\u001a\u000b\u0004y\u0005\u0015\u0003BB+\u000f\u0001\u0004\ty$\u0001\u0005hKR\u001c\u0005.Z2l)1\tY%!\u0015\u0002V\u0005e\u00131LA0!\r1\u0015QJ\u0005\u0004\u0003\u001f\u0002%a\u0003%fC2$\bn\u00115fG.Da!a\u0015\u0010\u0001\u0004I\u0018\u0001\u00028b[\u0016Da!a\u0016\u0010\u0001\u0004!\u0013\u0001B2p]\u001aDa!a\u0002\u0010\u0001\u0004I\bBBA/\u001f\u0001\u0007\u00110A\u0004bI\u0012\u0014Xm]:\t\u000f\u0005\u0005t\u00021\u0001\u0002d\u0005!\u0001o\u001c:u!\rQ\u0012QM\u0005\u0004\u0003OZ\"aA%oi\u0002")
public class ServiceProviderImpl
implements ServiceProvider {
    private String groupConfigPath;
    private volatile ServiceRegistry registry;
    private final Config config;
    private Service service;
    private volatile byte bitmap$0;

    private String groupConfigPath$lzycompute() {
        ServiceProviderImpl serviceProviderImpl = this;
        synchronized (serviceProviderImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.groupConfigPath = "dryad.group";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.groupConfigPath;
    }

    private String groupConfigPath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.groupConfigPath$lzycompute() : this.groupConfigPath;
    }

    private ServiceRegistry registry$lzycompute() {
        ServiceProviderImpl serviceProviderImpl = this;
        synchronized (serviceProviderImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String registryName = this.config.getString("dryad.registry");
                this.registry = (ServiceRegistry)Class.forName(registryName).newInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.registry;
    }

    private ServiceRegistry registry() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.registry$lzycompute() : this.registry;
    }

    @Override
    public void register() {
        this.initService((Seq<Tuple2<Enumeration.Value, Seq<String>>>)((Seq)Seq$.MODULE$.empty()));
        this.registry().register(this.service);
    }

    @Override
    public void deregister() {
        this.checkState();
        this.registry().deregister(this.service);
    }

    @Override
    public void register(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        this.initService(patterns);
        this.registry().register(this.service);
    }

    @Override
    public void subscribe(Enumeration.Value schema, String serviceName, ServiceInstanceListener listener) {
        String group = this.config.getString(this.groupConfigPath());
        this.registry().subscribe((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_global_", group}))), schema, serviceName, listener);
    }

    @Override
    public Seq<ServiceInstance> getInstances(Enumeration.Value schema, String serviceName, Option<ServiceInstanceListener> listener) {
        String group = this.config.getString(this.groupConfigPath());
        return this.registry().getInstances((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_global_", group}))), schema, serviceName, listener);
    }

    public Service getService() {
        this.checkState();
        return this.service;
    }

    private void checkState() {
        if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
            throw new IllegalStateException("service not init");
        }
    }

    public void initService(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
            ServiceProviderImpl serviceProviderImpl = this;
            synchronized (serviceProviderImpl) {
                if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
                    this.service = this.buildService(patterns);
                }
            }
        }
    }

    public Service buildService(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        String group = this.config.getString(this.groupConfigPath());
        String name = this.config.getString("dryad.namespace");
        Config serviceConfig = this.config.getConfig("dryad.service");
        String address = (String)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("address").getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getHostAddress());
        Set portals = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(serviceConfig.entrySet()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Map.Entry<String, ConfigValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = new StringOps(Predef$.MODULE$.augmentString(A1.getKey())).contains((Object)BoxesRunTime.boxToCharacter((char)'.')) ? A1.getKey() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map.Entry<String, ConfigValue> x1) {
                Map.Entry<String, ConfigValue> entry = x1;
                boolean bl = new StringOps(Predef$.MODULE$.augmentString(entry.getKey())).contains((Object)BoxesRunTime.boxToCharacter((char)'.'));
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split("\\."))).head()).keys().map((Function1 & Serializable & scala.Serializable)schema -> {
            Config portalConfig = serviceConfig.getConfig(schema);
            int port = portalConfig.getInt("port");
            String pattern = (String)patterns.collectFirst((PartialFunction)new scala.Serializable(null, (String)schema){
                public static final long serialVersionUID = 0L;
                private final String schema$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Enumeration.Value, Seq<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        Enumeration.Value s = (Enumeration.Value)A1._1();
                        Seq ps = (Seq)A1._2();
                        Enumeration.Value value = Schema$.MODULE$.withName(this.schema$1.toLowerCase());
                        Enumeration.Value value2 = s;
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            object = ps.mkString(",");
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<Enumeration.Value, Seq<String>> x2) {
                    Tuple2<Enumeration.Value, Seq<String>> tuple2 = x2;
                    if (tuple2 == null) return false;
                    Enumeration.Value s = (Enumeration.Value)tuple2._1();
                    Enumeration.Value value = Schema$.MODULE$.withName(this.schema$1.toLowerCase());
                    Enumeration.Value value2 = s;
                    if (value != null) {
                        if (!value.equals(value2)) return false;
                        return true;
                    }
                    if (value2 == null) return true;
                    return false;
                }
                {
                    this.schema$1 = schema$1;
                }
            }).fold((Function0 & Serializable & scala.Serializable)() -> (String)ConfigUtils$.MODULE$.ConfigWrapper(portalConfig).getStringOpt("pattern").getOrElse((Function0 & Serializable & scala.Serializable)() -> "/.*"), (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x));
            Seq nonCertifications = (Seq)ConfigUtils$.MODULE$.ConfigWrapper(portalConfig).getStringSeqOpt("non-certifications").map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.distinct()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            String id = Hashing.murmur3_128().hashString((CharSequence)new StringBuilder(0).append(address).append(new StringBuilder(2).append("-").append(port).append("-").append(group).toString()).toString(), Charsets.UTF_8).toString();
            return new Portal(id, Schema$.MODULE$.withName((String)schema), port, pattern, this.getCheck(name, portalConfig, (String)schema, address, port), (Seq<String>)nonCertifications);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        int priority = BoxesRunTime.unboxToInt((Object)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getIntOpt("priority").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option loadBalancing = ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("load-balancing").map((Function1 & Serializable & scala.Serializable)lb -> LoadBalancing$.MODULE$.withName((String)lb));
        return new Service(name, address, group, (Set<Portal>)portals, priority, (Option<Enumeration.Value>)loadBalancing);
    }

    public HealthCheck getCheck(String name, Config conf, String schema, String address, int port) {
        HealthCheck healthCheck;
        int factor = 10;
        Option<Config> option = ConfigUtils$.MODULE$.ConfigWrapper(conf).getConfigOpt("check");
        if (None$.MODULE$.equals(option)) {
            FiniteDuration ttl2 = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
            healthCheck = new TTLHealthCheck((Duration)ttl2, (Duration)ttl2.$times((long)factor));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Config checkConfig = (Config)some.value();
            LazyRef interval$lzy = new LazyRef();
            Option<Duration> deregisterCriticalServiceAfterOpt = ConfigUtils$.MODULE$.ConfigWrapper(conf).getDurationOpt("deregister-critical-service-after");
            Option ttl3 = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getDurationOpt("ttl").map((Function1 & Serializable & scala.Serializable)ttl -> {
                Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ttl.$times((double)factor));
                return new TTLHealthCheck((Duration)ttl, deregisterCriticalServiceAfter);
            });
            Option http = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getStringOpt("url").map((Function1 & Serializable & scala.Serializable)url -> {
                String _url = url.startsWith("/") ? new StringBuilder(4).append(schema).append("://").append(address).append(":").append(port).append((String)url).toString() : url;
                Duration timeout = (Duration)ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getDurationOpt("timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
                Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ServiceProviderImpl.interval$1(interval$lzy, checkConfig).$times((double)factor));
                return new HttpHealthCheck(_url, ServiceProviderImpl.interval$1(interval$lzy, checkConfig), timeout, deregisterCriticalServiceAfter);
            });
            Option grpc = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getBooleanOpt("grpc-use-tls").map((Function1 & Serializable & scala.Serializable)useTls -> ServiceProviderImpl.$anonfun$getCheck$7(deregisterCriticalServiceAfterOpt, factor, address, port, name, interval$lzy, checkConfig, BoxesRunTime.unboxToBoolean((Object)useTls)));
            healthCheck = (HealthCheck)ttl3.orElse((Function0 & Serializable & scala.Serializable)() -> http).orElse((Function0 & Serializable & scala.Serializable)() -> grpc).get();
        } else {
            throw new MatchError(option);
        }
        return healthCheck;
    }

    private static final /* synthetic */ Duration interval$lzycompute$1(LazyRef interval$lzy$1, Config checkConfig$1) {
        Duration duration;
        LazyRef lazyRef = interval$lzy$1;
        synchronized (lazyRef) {
            duration = interval$lzy$1.initialized() ? (Duration)interval$lzy$1.value() : (Duration)interval$lzy$1.initialize(ConfigUtils$.MODULE$.ConfigWrapper(checkConfig$1).getDurationOpt("interval").getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
        }
        return duration;
    }

    private static final Duration interval$1(LazyRef interval$lzy$1, Config checkConfig$1) {
        return interval$lzy$1.initialized() ? (Duration)interval$lzy$1.value() : ServiceProviderImpl.interval$lzycompute$1(interval$lzy$1, checkConfig$1);
    }

    public static final /* synthetic */ GrpcHealthCheck $anonfun$getCheck$7(Option deregisterCriticalServiceAfterOpt$1, int factor$1, String address$2, int port$1, String name$2, LazyRef interval$lzy$1, Config checkConfig$1, boolean useTls) {
        Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> ServiceProviderImpl.interval$1(interval$lzy$1, checkConfig$1).$times((double)factor$1));
        return new GrpcHealthCheck(new StringBuilder(2).append(address$2).append(":").append(port$1).append("/").append(name$2).toString(), ServiceProviderImpl.interval$1(interval$lzy$1, checkConfig$1), useTls, deregisterCriticalServiceAfter);
    }

    public ServiceProviderImpl(Config config) {
        this.config = config;
    }
}

