/*
 * Decompiled with CFR 0.152.
 */
package io.growing.dryad;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.growing.dryad.ServiceProvider;
import io.growing.dryad.listener.ServiceInstanceListener;
import io.growing.dryad.portal.Schema$;
import io.growing.dryad.registry.GrpcHealthCheck;
import io.growing.dryad.registry.HealthCheck;
import io.growing.dryad.registry.HttpHealthCheck;
import io.growing.dryad.registry.ServiceRegistry;
import io.growing.dryad.registry.TTLHealthCheck;
import io.growing.dryad.registry.dto.LoadBalancing$;
import io.growing.dryad.registry.dto.Portal;
import io.growing.dryad.registry.dto.Service;
import io.growing.dryad.registry.dto.ServiceInstance;
import io.growing.dryad.util.ConfigUtils$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001%\u00111cU3sm&\u001cW\r\u0015:pm&$WM]%na2T!a\u0001\u0003\u0002\u000b\u0011\u0014\u00180\u00193\u000b\u0005\u00151\u0011aB4s_^Lgn\u001a\u0006\u0002\u000f\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!aD*feZL7-\u001a)s_ZLG-\u001a:\t\u0011U\u0001!\u0011!Q\u0001\nY\taaY8oM&<\u0007CA\f\u001e\u001b\u0005A\"BA\u000b\u001a\u0015\tQ2$\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0012aA2p[&\u0011a\u0004\u0007\u0002\u0007\u0007>tg-[4\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\t\u00113\u0005\u0005\u0002\u0012\u0001!)Qc\ba\u0001-!AQ\u0005\u0001ECB\u0013%a%A\bhe>,\boQ8oM&<\u0007+\u0019;i+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u0013A\u0002\u0001\u0019!A!B\u0013\t\u0014aB:feZL7-\u001a\t\u0003e]j\u0011a\r\u0006\u0003iU\n1\u0001\u001a;p\u0015\t1$!\u0001\u0005sK\u001eL7\u000f\u001e:z\u0013\tA4GA\u0004TKJ4\u0018nY3\t\u0011Y\u0002\u0001R1Q\u0005\ni*\u0012a\u000f\t\u0003yuj\u0011!N\u0005\u0003}U\u0012qbU3sm&\u001cWMU3hSN$(/\u001f\u0015\u0003s\u0001\u0003\"aC!\n\u0005\tc!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000b\u0011\u0003A\u0011I#\u0002\u0011I,w-[:uKJ$\u0012A\u0012\t\u0003\u0017\u001dK!\u0001\u0013\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u0002!\t%R\u0001\u000bI\u0016\u0014XmZ5ti\u0016\u0014\b\"\u0002#\u0001\t\u0003bEC\u0001$N\u0011\u0015q5\n1\u0001P\u0003!\u0001\u0018\r\u001e;fe:\u001c\bcA\u0006Q%&\u0011\u0011\u000b\u0004\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003B\u0006T+&L!\u0001\u0016\u0007\u0003\rQ+\b\u000f\\33!\t1fM\u0004\u0002XG:\u0011\u0001,\u0019\b\u00033\u0002t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uC\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\t)a!\u0003\u0002\u0004\t%\u0011!MA\u0001\u0007a>\u0014H/\u00197\n\u0005\u0011,\u0017AB*dQ\u0016l\u0017M\u0003\u0002c\u0005%\u0011q\r\u001b\u0002\u0007'\u000eDW-\\1\u000b\u0005\u0011,\u0007c\u00016pe:\u00111.\u001c\b\u000372L\u0011!D\u0005\u0003]2\tq\u0001]1dW\u0006<W-\u0003\u0002qc\n\u00191+Z9\u000b\u00059d\u0001CA:x\u001d\t!X\u000f\u0005\u0002\\\u0019%\u0011a\u000fD\u0001\u0007!J,G-\u001a4\n\u00059B(B\u0001<\r\u0011\u0015Q\b\u0001\"\u0011|\u0003%\u0019XOY:de&\u0014W\rF\u0003Gyz\f\t\u0001C\u0003~s\u0002\u0007Q+\u0001\u0004tG\",W.\u0019\u0005\u0006\u007ff\u0004\rA]\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW\rC\u0004\u0002\u0004e\u0004\r!!\u0002\u0002\u00111L7\u000f^3oKJ\u0004B!a\u0002\u0002\f5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0007\u0011\u0011\u0002BA\u0007\u0003\u0013\u0011qcU3sm&\u001cW-\u00138ti\u0006t7-\u001a'jgR,g.\u001a:\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014\u0005aq-\u001a;J]N$\u0018M\\2fgRA\u0011QCA\u000f\u0003?\t\t\u0003\u0005\u0003k_\u0006]\u0001c\u0001\u001a\u0002\u001a%\u0019\u00111D\u001a\u0003\u001fM+'O^5dK&s7\u000f^1oG\u0016Da!`A\b\u0001\u0004)\u0006BB@\u0002\u0010\u0001\u0007!\u000f\u0003\u0005\u0002\u0004\u0005=\u0001\u0019AA\u0012!\u0015Y\u0011QEA\u0003\u0013\r\t9\u0003\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005Qq-\u001a;TKJ4\u0018nY3\u0016\u0003EBq!!\r\u0001A\u0013%Q)\u0001\u0006dQ\u0016\u001c7n\u0015;bi\u0016D\u0001\"!\u000e\u0001\t\u0003\u0011\u0011qG\u0001\fS:LGoU3sm&\u001cW\rF\u0002G\u0003sAqATA\u001a\u0001\u0004\tY\u0004E\u0002k_JC\u0001\"a\u0010\u0001\t\u0003\u0011\u0011\u0011I\u0001\rEVLG\u000eZ*feZL7-\u001a\u000b\u0004c\u0005\r\u0003b\u0002(\u0002>\u0001\u0007\u00111\b\u0005\t\u0003\u000f\u0002A\u0011\u0001\u0002\u0002J\u0005Aq-\u001a;DQ\u0016\u001c7\u000e\u0006\u0007\u0002L\u0005E\u0013QKA-\u00037\ny\u0006E\u0002=\u0003\u001bJ1!a\u00146\u0005-AU-\u00197uQ\u000eCWmY6\t\u000f\u0005M\u0013Q\ta\u0001e\u0006!a.Y7f\u0011\u001d\t9&!\u0012A\u0002Y\tAaY8oM\"1Q0!\u0012A\u0002IDq!!\u0018\u0002F\u0001\u0007!/A\u0004bI\u0012\u0014Xm]:\t\u0011\u0005\u0005\u0014Q\ta\u0001\u0003G\nA\u0001]8siB\u00191\"!\u001a\n\u0007\u0005\u001dDBA\u0002J]R\u0004")
public class ServiceProviderImpl
implements ServiceProvider {
    private String groupConfigPath;
    private volatile ServiceRegistry registry;
    private final Config config;
    private Service service;
    private volatile byte bitmap$0;

    private String groupConfigPath$lzycompute() {
        ServiceProviderImpl serviceProviderImpl = this;
        synchronized (serviceProviderImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.groupConfigPath = "dryad.group";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.groupConfigPath;
    }

    private String groupConfigPath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.groupConfigPath$lzycompute() : this.groupConfigPath;
    }

    private ServiceRegistry registry$lzycompute() {
        ServiceProviderImpl serviceProviderImpl = this;
        synchronized (serviceProviderImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String registryName = this.config.getString("dryad.registry");
                this.registry = (ServiceRegistry)Class.forName(registryName).newInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.registry;
    }

    private ServiceRegistry registry() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.registry$lzycompute() : this.registry;
    }

    @Override
    public void register() {
        this.initService((Seq<Tuple2<Enumeration.Value, Seq<String>>>)((Seq)Seq$.MODULE$.empty()));
        this.registry().register(this.service);
    }

    @Override
    public void deregister() {
        this.checkState();
        this.registry().deregister(this.service);
    }

    @Override
    public void register(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        this.initService(patterns);
        this.registry().register(this.service);
    }

    @Override
    public void subscribe(Enumeration.Value schema, String serviceName, ServiceInstanceListener listener) {
        String group = this.config.getString(this.groupConfigPath());
        this.registry().subscribe((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_global_", group}))), schema, serviceName, listener);
    }

    @Override
    public Seq<ServiceInstance> getInstances(Enumeration.Value schema, String serviceName, Option<ServiceInstanceListener> listener) {
        String group = this.config.getString(this.groupConfigPath());
        return this.registry().getInstances((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_global_", group}))), schema, serviceName, listener);
    }

    public Service getService() {
        this.checkState();
        return this.service;
    }

    private void checkState() {
        if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
            throw new IllegalStateException("service not init");
        }
    }

    public void initService(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
            ServiceProviderImpl serviceProviderImpl = this;
            synchronized (serviceProviderImpl) {
                if (Option$.MODULE$.apply((Object)this.service).isEmpty()) {
                    this.service = this.buildService(patterns);
                }
            }
        }
    }

    public Service buildService(Seq<Tuple2<Enumeration.Value, Seq<String>>> patterns) {
        String group = this.config.getString(this.groupConfigPath());
        String name = this.config.getString("dryad.namespace");
        Config serviceConfig = this.config.getConfig("dryad.service");
        String address = (String)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("address").getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getHostAddress());
        Set portals = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(serviceConfig.entrySet()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Map.Entry<String, ConfigValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = new StringOps(Predef$.MODULE$.augmentString(A1.getKey())).contains((Object)BoxesRunTime.boxToCharacter((char)'.')) ? A1.getKey() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map.Entry<String, ConfigValue> x1) {
                Map.Entry<String, ConfigValue> entry = x1;
                boolean bl = new StringOps(Predef$.MODULE$.augmentString(entry.getKey())).contains((Object)BoxesRunTime.boxToCharacter((char)'.'));
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split("\\."))).head()).keys().map((Function1 & Serializable & scala.Serializable)schema -> {
            Config portalConfig = serviceConfig.getConfig(schema);
            int port = portalConfig.getInt("port");
            String pattern = (String)patterns.collectFirst((PartialFunction)new scala.Serializable(null, (String)schema){
                public static final long serialVersionUID = 0L;
                private final String schema$2;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Enumeration.Value, Seq<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        Enumeration.Value s = (Enumeration.Value)A1._1();
                        Seq ps = (Seq)A1._2();
                        Enumeration.Value value = Schema$.MODULE$.withName(this.schema$2.toLowerCase());
                        Enumeration.Value value2 = s;
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            object = ps.mkString(",");
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<Enumeration.Value, Seq<String>> x2) {
                    Tuple2<Enumeration.Value, Seq<String>> tuple2 = x2;
                    if (tuple2 == null) return false;
                    Enumeration.Value s = (Enumeration.Value)tuple2._1();
                    Enumeration.Value value = Schema$.MODULE$.withName(this.schema$2.toLowerCase());
                    Enumeration.Value value2 = s;
                    if (value != null) {
                        if (!value.equals(value2)) return false;
                        return true;
                    }
                    if (value2 == null) return true;
                    return false;
                }
                {
                    this.schema$2 = schema$2;
                }
            }).fold((Function0 & Serializable & scala.Serializable)() -> (String)ConfigUtils$.MODULE$.ConfigWrapper(portalConfig).getStringOpt("pattern").getOrElse((Function0 & Serializable & scala.Serializable)() -> "/.*"), (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x));
            Seq nonCertifications = (Seq)ConfigUtils$.MODULE$.ConfigWrapper(portalConfig).getStringSeqOpt("non-certifications").map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.distinct()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            String id = Hashing.murmur3_128().hashString((CharSequence)new StringBuilder(0).append(address).append(new StringBuilder(2).append("-").append(port).append("-").append(group).toString()).toString(), Charsets.UTF_8).toString();
            return new Portal(id, Schema$.MODULE$.withName((String)schema), port, pattern, this.getCheck(name, portalConfig, (String)schema, address, port), (Seq<String>)nonCertifications);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        int priority = BoxesRunTime.unboxToInt((Object)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getIntOpt("priority").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option loadBalancing = ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("load-balancing").map((Function1 & Serializable & scala.Serializable)lb -> LoadBalancing$.MODULE$.withName((String)lb));
        return new Service(name, address, group, (Set<Portal>)portals, priority, (Option<Enumeration.Value>)loadBalancing);
    }

    public HealthCheck getCheck(String name, Config conf, String schema, String address, int port) {
        HealthCheck healthCheck;
        int factor = 10;
        Option<Config> option = ConfigUtils$.MODULE$.ConfigWrapper(conf).getConfigOpt("check");
        if (None$.MODULE$.equals(option)) {
            FiniteDuration ttl2 = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
            healthCheck = new TTLHealthCheck((Duration)ttl2, (Duration)ttl2.$times((long)factor));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Config checkConfig = (Config)some.value();
            LazyRef interval$lzy = new LazyRef();
            Option<Duration> deregisterCriticalServiceAfterOpt = ConfigUtils$.MODULE$.ConfigWrapper(conf).getDurationOpt("deregister-critical-service-after");
            Option ttl3 = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getDurationOpt("ttl").map((Function1 & Serializable & scala.Serializable)ttl -> {
                Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ttl.$times((double)factor));
                return new TTLHealthCheck((Duration)ttl, deregisterCriticalServiceAfter);
            });
            Option http = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getStringOpt("url").map((Function1 & Serializable & scala.Serializable)url -> {
                String _url = url.startsWith("/") ? new StringBuilder(4).append(schema).append("://").append(address).append(":").append(port).append((String)url).toString() : url;
                Duration timeout = (Duration)ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getDurationOpt("timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
                Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ServiceProviderImpl.interval$1(checkConfig, interval$lzy).$times((double)factor));
                return new HttpHealthCheck(_url, ServiceProviderImpl.interval$1(checkConfig, interval$lzy), timeout, deregisterCriticalServiceAfter);
            });
            Option grpc = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getBooleanOpt("grpc-use-tls").map((Function1 & Serializable & scala.Serializable)useTls -> ServiceProviderImpl.$anonfun$getCheck$7(name, address, port, factor, checkConfig, deregisterCriticalServiceAfterOpt, interval$lzy, BoxesRunTime.unboxToBoolean((Object)useTls)));
            healthCheck = (HealthCheck)ttl3.orElse((Function0 & Serializable & scala.Serializable)() -> http).orElse((Function0 & Serializable & scala.Serializable)() -> grpc).get();
        } else {
            throw new MatchError(option);
        }
        return healthCheck;
    }

    private static final /* synthetic */ Duration interval$lzycompute$1(Config checkConfig$1, LazyRef interval$lzy$1) {
        Duration duration;
        LazyRef lazyRef = interval$lzy$1;
        synchronized (lazyRef) {
            duration = interval$lzy$1.initialized() ? (Duration)interval$lzy$1.value() : (Duration)interval$lzy$1.initialize(ConfigUtils$.MODULE$.ConfigWrapper(checkConfig$1).getDurationOpt("interval").getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
        }
        return duration;
    }

    private static final Duration interval$1(Config checkConfig$1, LazyRef interval$lzy$1) {
        return interval$lzy$1.initialized() ? (Duration)interval$lzy$1.value() : ServiceProviderImpl.interval$lzycompute$1(checkConfig$1, interval$lzy$1);
    }

    public static final /* synthetic */ GrpcHealthCheck $anonfun$getCheck$7(String name$2, String address$2, int port$1, int factor$1, Config checkConfig$1, Option deregisterCriticalServiceAfterOpt$1, LazyRef interval$lzy$1, boolean useTls) {
        Duration deregisterCriticalServiceAfter = (Duration)deregisterCriticalServiceAfterOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> ServiceProviderImpl.interval$1(checkConfig$1, interval$lzy$1).$times((double)factor$1));
        return new GrpcHealthCheck(new StringBuilder(2).append(address$2).append(":").append(port$1).append("/").append(name$2).toString(), ServiceProviderImpl.interval$1(checkConfig$1, interval$lzy$1), useTls, deregisterCriticalServiceAfter);
    }

    public ServiceProviderImpl(Config config) {
        this.config = config;
    }
}

