/*
 * Decompiled with CFR 0.152.
 */
package io.growing.dryad.registry.impl;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.typesafe.config.Config;
import io.growing.dryad.registry.HealthCheck;
import io.growing.dryad.registry.HttpHealthCheck;
import io.growing.dryad.registry.ServiceProvider;
import io.growing.dryad.registry.ServiceRegistry;
import io.growing.dryad.registry.TTLHealthCheck;
import io.growing.dryad.registry.dto.Service;
import io.growing.dryad.util.ConfigUtils$;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\t\u00192+\u001a:wS\u000e,\u0007K]8wS\u0012,'/S7qY*\u00111\u0001B\u0001\u0005S6\u0004HN\u0003\u0002\u0006\r\u0005A!/Z4jgR\u0014\u0018P\u0003\u0002\b\u0011\u0005)AM]=bI*\u0011\u0011BC\u0001\bOJ|w/\u001b8h\u0015\u0005Y\u0011AA5p\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\u0010'\u0016\u0014h/[2f!J|g/\u001b3fe\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0004d_:4\u0017n\u001a\t\u00037\u0005j\u0011\u0001\b\u0006\u00033uQ!AH\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001I\u0001\u0004G>l\u0017B\u0001\u0012\u001d\u0005\u0019\u0019uN\u001c4jO\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"A\n\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000be\u0019\u0003\u0019\u0001\u000e\t\r\u0015\u0001\u0001\u0015!\u0003+!\t)2&\u0003\u0002-\t\ty1+\u001a:wS\u000e,'+Z4jgR\u0014\u0018\u0010\u0003\u0004/\u0001\u0001\u0006IaL\u0001\bg\u0016\u0014h/[2f!\t\u00014'D\u00012\u0015\t\u0011D!A\u0002ei>L!\u0001N\u0019\u0003\u000fM+'O^5dK\"1a\u0007\u0001Q\u0005\n]\n\u0001bZ3u\u0007\",7m\u001b\u000b\u0006qmj$\n\u0014\t\u0003+eJ!A\u000f\u0003\u0003\u0017!+\u0017\r\u001c;i\u0007\",7m\u001b\u0005\u0006yU\u0002\rAG\u0001\u0005G>tg\rC\u0003?k\u0001\u0007q(\u0001\u0004tG\",W.\u0019\t\u0003\u0001\u001es!!Q#\u0011\u0005\t\u0003R\"A\"\u000b\u0005\u0011c\u0011A\u0002\u001fs_>$h(\u0003\u0002G!\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0005\u0003C\u0003Lk\u0001\u0007q(A\u0004bI\u0012\u0014Xm]:\t\u000b5+\u0004\u0019\u0001(\u0002\tA|'\u000f\u001e\t\u0003\u001f=K!\u0001\u0015\t\u0003\u0007%sG\u000fC\u0003S\u0001\u0011\u00053+\u0001\u0004p]2Lg.\u001a\u000b\u0002)B\u0011q\"V\u0005\u0003-B\u0011A!\u00168ji\")\u0001\f\u0001C!'\u00069qN\u001a4mS:,\u0007")
public class ServiceProviderImpl
implements ServiceProvider {
    private final ServiceRegistry registry;
    private final Service service;

    private HealthCheck getCheck(Config conf, String schema, String address, int port) {
        HealthCheck healthCheck;
        Option<Config> option = ConfigUtils$.MODULE$.ConfigWrapper(conf).getConfigOpt("check");
        if (None$.MODULE$.equals(option)) {
            healthCheck = new TTLHealthCheck(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds().toSeconds());
        } else if (option instanceof Some) {
            Config checkConfig = (Config)((Some)option).value();
            Option ttl2 = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getLongOpt("ttl").map((Function1 & Serializable & scala.Serializable)ttl -> ServiceProviderImpl.$anonfun$getCheck$1(BoxesRunTime.unboxToLong((Object)ttl)));
            Option http = ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getStringOpt("url").map((Function1 & Serializable & scala.Serializable)url -> {
                String _url = url.startsWith("/") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema, address, BoxesRunTime.boxToInteger((int)port), url})) : url;
                long interval = BoxesRunTime.unboxToLong((Object)ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getLongOpt("interval").getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds().toSeconds()));
                long timeout = BoxesRunTime.unboxToLong((Object)ConfigUtils$.MODULE$.ConfigWrapper(checkConfig).getLongOpt("timeout").getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds().toSeconds()));
                return new HttpHealthCheck(_url, interval, timeout);
            });
            healthCheck = (HealthCheck)ttl2.orElse((Function0 & Serializable & scala.Serializable)() -> http).get();
        } else {
            throw new MatchError(option);
        }
        return healthCheck;
    }

    @Override
    public void online() {
        this.registry.register(this.service);
    }

    @Override
    public void offline() {
        this.registry.deregister(this.service.id());
    }

    public static final /* synthetic */ TTLHealthCheck $anonfun$getCheck$1(long ttl) {
        return new TTLHealthCheck(ttl);
    }

    public ServiceProviderImpl(Config config) {
        this.registry = (ServiceRegistry)Class.forName(config.getString("dryad.registry")).newInstance();
        String group = config.getString("dryad.group");
        String name = config.getString("dryad.namespace");
        Config serviceConfig = config.getConfig("dryad.service");
        int port = serviceConfig.getInt("port");
        int priority = BoxesRunTime.unboxToInt((Object)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getIntOpt("priority").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        String pattern = (String)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("pattern").getOrElse((Function0 & Serializable & scala.Serializable)() -> "/*");
        String schema = (String)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("schema").getOrElse((Function0 & Serializable & scala.Serializable)() -> "http");
        String address = (String)ConfigUtils$.MODULE$.ConfigWrapper(serviceConfig).getStringOpt("address").getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getHostAddress());
        String id = Hashing.md5().hashString((CharSequence)(address + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port), group}))), Charsets.UTF_8).toString();
        HealthCheck check = this.getCheck(serviceConfig, schema, address, port);
        this.service = new Service(id, name, schema, address, port, pattern, group, check, priority);
    }
}

