/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model.responsewrapper;

import com.google.gson.annotations.SerializedName;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperTokenSecurityDex;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperTokenSecurityLpHolders;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="key is contract address")
public class ResponseWrapperTokenSecurityResult {
    @SerializedName(value="note")
    private String note = null;
    @SerializedName(value="lp_total_supply")
    private String lpTotalSupply = null;
    @SerializedName(value="lp_holders")
    private List<ResponseWrapperTokenSecurityLpHolders> lpHolders = null;
    @SerializedName(value="is_airdrop_scam")
    private String isAirdropScam = null;
    @SerializedName(value="other_potential_risks")
    private String otherPotentialRisks = null;
    @SerializedName(value="transfer_pausable")
    private String transferPausable = null;
    @SerializedName(value="trading_cooldown")
    private String tradingCooldown = null;
    @SerializedName(value="hidden_owner")
    private String hiddenOwner = null;
    @SerializedName(value="selfdestruct")
    private String selfdestruct = null;
    @SerializedName(value="owner_percent")
    private String ownerPercent = null;
    @SerializedName(value="is_whitelisted")
    private String isWhitelisted = null;
    @SerializedName(value="holder_count")
    private String holderCount = null;
    @SerializedName(value="trust_list")
    private String trustList = null;
    @SerializedName(value="is_honeypot")
    private String isHoneypot = null;
    @SerializedName(value="holders")
    private List<ResponseWrapperTokenSecurityLpHolders> holders = null;
    @SerializedName(value="dex")
    private List<ResponseWrapperTokenSecurityDex> dex = null;
    @SerializedName(value="is_open_source")
    private String isOpenSource = null;
    @SerializedName(value="sell_tax")
    private String sellTax = null;
    @SerializedName(value="token_name")
    private String tokenName = null;
    @SerializedName(value="creator_address")
    private String creatorAddress = null;
    @SerializedName(value="creator_percent")
    private String creatorPercent = null;
    @SerializedName(value="is_proxy")
    private String isProxy = null;
    @SerializedName(value="creator_balance")
    private String creatorBalance = null;
    @SerializedName(value="is_in_dex")
    private String isInDex = null;
    @SerializedName(value="owner_balance")
    private String ownerBalance = null;
    @SerializedName(value="total_supply")
    private String totalSupply = null;
    @SerializedName(value="is_true_token")
    private String isTrueToken = null;
    @SerializedName(value="can_take_back_ownership")
    private String canTakeBackOwnership = null;
    @SerializedName(value="is_blacklisted")
    private String isBlacklisted = null;
    @SerializedName(value="owner_address")
    private String ownerAddress = null;
    @SerializedName(value="slippage_modifiable")
    private String slippageModifiable = null;
    @SerializedName(value="buy_tax")
    private String buyTax = null;
    @SerializedName(value="external_call")
    private String externalCall = null;
    @SerializedName(value="cannot_sell_all")
    private String cannotSellAll = null;
    @SerializedName(value="lp_holder_count")
    private String lpHolderCount = null;
    @SerializedName(value="personal_slippage_modifiable")
    private String personalSlippageModifiable = null;
    @SerializedName(value="is_anti_whale")
    private String isAntiWhale = null;
    @SerializedName(value="is_mintable")
    private String isMintable = null;
    @SerializedName(value="owner_change_balance")
    private String ownerChangeBalance = null;
    @SerializedName(value="cannot_buy")
    private String cannotBuy = null;
    @SerializedName(value="anti_whale_modifiable")
    private String antiWhaleModifiable = null;
    @SerializedName(value="token_symbol")
    private String tokenSymbol = null;

    public ResponseWrapperTokenSecurityResult note(String note) {
        this.note = note;
        return this;
    }

    @Schema(description="It describes whether the contract has other things investors need to know.  Example:  \"note\u201d: \u201cContract owner is a multisign contract.\u201d(Notice:(1) If we haven't found any other thing which is valuable yet, there will be no return.  (2) Type: string.)")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public ResponseWrapperTokenSecurityResult lpTotalSupply(String lpTotalSupply) {
        this.lpTotalSupply = lpTotalSupply;
        return this;
    }

    @Schema(description="It describes the supply number of the LP token. Example:\"lp_total_supply\": \"100000000\". No return means no LP.(Notice:(1) When \"is_in_dex\": \"0\", there will be no return.  (2) It is LP token number, NOT token number)")
    public String getLpTotalSupply() {
        return this.lpTotalSupply;
    }

    public void setLpTotalSupply(String lpTotalSupply) {
        this.lpTotalSupply = lpTotalSupply;
    }

    public ResponseWrapperTokenSecurityResult lpHolders(List<ResponseWrapperTokenSecurityLpHolders> lpHolders) {
        this.lpHolders = lpHolders;
        return this;
    }

    public ResponseWrapperTokenSecurityResult addLpHoldersItem(ResponseWrapperTokenSecurityLpHolders lpHoldersItem) {
        if (this.lpHolders == null) {
            this.lpHolders = new ArrayList<ResponseWrapperTokenSecurityLpHolders>();
        }
        this.lpHolders.add(lpHoldersItem);
        return this;
    }

    @Schema(description="Top10 LP token holders info(Notice:When \"is_in_dex\": \"0\", there will be no return. )")
    public List<ResponseWrapperTokenSecurityLpHolders> getLpHolders() {
        return this.lpHolders;
    }

    public void setLpHolders(List<ResponseWrapperTokenSecurityLpHolders> lpHolders) {
        this.lpHolders = lpHolders;
    }

    public ResponseWrapperTokenSecurityResult isAirdropScam(String isAirdropScam) {
        this.isAirdropScam = isAirdropScam;
        return this;
    }

    @Schema(description="It describes whether the token is an airdrop scam. \"1\" means true; \"0\" means false; None means no result (Because We did not find conclusive information on whether token is an airdrop scam).(Notice:Only \"is_airdrop_scam\": \"1\" means it is an airdrop scam.)")
    public String getIsAirdropScam() {
        return this.isAirdropScam;
    }

    public void setIsAirdropScam(String isAirdropScam) {
        this.isAirdropScam = isAirdropScam;
    }

    public ResponseWrapperTokenSecurityResult otherPotentialRisks(String otherPotentialRisks) {
        this.otherPotentialRisks = otherPotentialRisks;
        return this;
    }

    @Schema(description="It describes whether the contract has other potential risks. Example: \u201cother_potential_risks\u201d: \u201cOwner can set different transaction taxes for each user, which can trigger serious losses.\u201d(Notice:(1) If we haven't found any other potential risk yet, there will be no return.  (2) Type: string.)")
    public String getOtherPotentialRisks() {
        return this.otherPotentialRisks;
    }

    public void setOtherPotentialRisks(String otherPotentialRisks) {
        this.otherPotentialRisks = otherPotentialRisks;
    }

    public ResponseWrapperTokenSecurityResult transferPausable(String transferPausable) {
        this.transferPausable = transferPausable;
        return this;
    }

    @Schema(description="It describes whether trading can be pausable by token contract. \"1\" means true; \"0\" means false; No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) This feature means that the contract owner will be able to suspend trading at any time, after that anyone will not be able to sell, except those who have special authority.  (4) This function generally relies on ownership. When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, this function will most likely be disabled.)")
    public String getTransferPausable() {
        return this.transferPausable;
    }

    public void setTransferPausable(String transferPausable) {
        this.transferPausable = transferPausable;
    }

    public ResponseWrapperTokenSecurityResult tradingCooldown(String tradingCooldown) {
        this.tradingCooldown = tradingCooldown;
        return this;
    }

    @Schema(description="It describes whether the contract has trading-cool-down mechanism which can limits the minimum time between two transactions. \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return. (2) Sometimes, when \"is_proxy\": \"1\", there will be no return. )")
    public String getTradingCooldown() {
        return this.tradingCooldown;
    }

    public void setTradingCooldown(String tradingCooldown) {
        this.tradingCooldown = tradingCooldown;
    }

    public ResponseWrapperTokenSecurityResult hiddenOwner(String hiddenOwner) {
        this.hiddenOwner = hiddenOwner;
        return this;
    }

    @Schema(description="It describes whether the contract has hidden owners. For contract with a hidden owner, developer can still manipulate the contract even if the ownership has been abandoned. \u201c1\u201d means true; \"0\" means false; No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Hidden owner is often used by developers to hide ownership and is often accompanied by malicious functionality. When the hidden owner exists, it is assumed that ownership has not been abandoned.)")
    public String getHiddenOwner() {
        return this.hiddenOwner;
    }

    public void setHiddenOwner(String hiddenOwner) {
        this.hiddenOwner = hiddenOwner;
    }

    public ResponseWrapperTokenSecurityResult selfdestruct(String selfdestruct) {
        this.selfdestruct = selfdestruct;
        return this;
    }

    @Schema(description="It describes whether this contract can self destruct. \"1\" means true;  \"0\" means false; No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) When the self-destruct function is triggered, this contract will be destroyed, all functions will be unavailable, and all related assets will be erased.)")
    public String getSelfdestruct() {
        return this.selfdestruct;
    }

    public void setSelfdestruct(String selfdestruct) {
        this.selfdestruct = selfdestruct;
    }

    public ResponseWrapperTokenSecurityResult ownerPercent(String ownerPercent) {
        this.ownerPercent = ownerPercent;
        return this;
    }

    @Schema(description="It describes the percentage of tokens held by the contract owner.  Example:\"owner_balance\": \"0.1\".  No return or return empty means there is no ownership or can't find ownership.(Notice:(1) 1 means 100% here. (2) When \"owner_address\" returns empty, or no return, there will be no return.)")
    public String getOwnerPercent() {
        return this.ownerPercent;
    }

    public void setOwnerPercent(String ownerPercent) {
        this.ownerPercent = ownerPercent;
    }

    public ResponseWrapperTokenSecurityResult isWhitelisted(String isWhitelisted) {
        this.isWhitelisted = isWhitelisted;
        return this;
    }

    @Schema(description="It describes whether the whitelist function is not included in the contract. If there is a whitelist, some addresses may not be able to trade normally. \"1\" means true; \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Whitelisting is mostly used to allow specific addresses to make early transactions, tax-free, and not affected by transaction suspension. (4) For contracts without an owner (or the owner is a black hole address), the whitelist will not be able to get updated. However, the existing whitelist is still in effect.)")
    public String getIsWhitelisted() {
        return this.isWhitelisted;
    }

    public void setIsWhitelisted(String isWhitelisted) {
        this.isWhitelisted = isWhitelisted;
    }

    public ResponseWrapperTokenSecurityResult holderCount(String holderCount) {
        this.holderCount = holderCount;
        return this;
    }

    @Schema(description="It describes the number of token holders. Example:\"holder_count\": \"4342\"")
    public String getHolderCount() {
        return this.holderCount;
    }

    public void setHolderCount(String holderCount) {
        this.holderCount = holderCount;
    }

    public ResponseWrapperTokenSecurityResult trustList(String trustList) {
        this.trustList = trustList;
        return this;
    }

    @Schema(description="It describes whether the token is a famous and trustworthy one. \"1\" means true; No return no result (Because We did not find conclusive information on whether token is a airdrop scam).(Notice:(1) Only \"trust_list\": \"1\" means it is a famous and trustworthy token.  (2) No return doesn't mean it is risky.)")
    public String getTrustList() {
        return this.trustList;
    }

    public void setTrustList(String trustList) {
        this.trustList = trustList;
    }

    public ResponseWrapperTokenSecurityResult isHoneypot(String isHoneypot) {
        this.isHoneypot = isHoneypot;
        return this;
    }

    @Schema(description="It describes whether the token is a honeypot. \"HoneyPot\" means that the token maybe cannot be sold because of the token contract's function, Or the token contains malicious code.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Hight risk, definitely scam.)")
    public String getIsHoneypot() {
        return this.isHoneypot;
    }

    public void setIsHoneypot(String isHoneypot) {
        this.isHoneypot = isHoneypot;
    }

    public ResponseWrapperTokenSecurityResult holders(List<ResponseWrapperTokenSecurityLpHolders> holders) {
        this.holders = holders;
        return this;
    }

    public ResponseWrapperTokenSecurityResult addHoldersItem(ResponseWrapperTokenSecurityLpHolders holdersItem) {
        if (this.holders == null) {
            this.holders = new ArrayList<ResponseWrapperTokenSecurityLpHolders>();
        }
        this.holders.add(holdersItem);
        return this;
    }

    @Schema(description="Top10 holders info")
    public List<ResponseWrapperTokenSecurityLpHolders> getHolders() {
        return this.holders;
    }

    public void setHolders(List<ResponseWrapperTokenSecurityLpHolders> holders) {
        this.holders = holders;
    }

    public ResponseWrapperTokenSecurityResult dex(List<ResponseWrapperTokenSecurityDex> dex) {
        this.dex = dex;
        return this;
    }

    public ResponseWrapperTokenSecurityResult addDexItem(ResponseWrapperTokenSecurityDex dexItem) {
        if (this.dex == null) {
            this.dex = new ArrayList<ResponseWrapperTokenSecurityDex>();
        }
        this.dex.add(dexItem);
        return this;
    }

    @Schema(description="It describes Dex information of where the token that can be traded.(Notice:When \"is_in_dex\": \"0\", there will be empty array. )")
    public List<ResponseWrapperTokenSecurityDex> getDex() {
        return this.dex;
    }

    public void setDex(List<ResponseWrapperTokenSecurityDex> dex) {
        this.dex = dex;
    }

    public ResponseWrapperTokenSecurityResult isOpenSource(String isOpenSource) {
        this.isOpenSource = isOpenSource;
        return this;
    }

    @Schema(description="It describes whether this contract is open source.  \"1\" means true;  \"0\" means false.(Notice:Un-open-sourced contracts may hide various unknown mechanisms and are extremely risky. When the contract is not open source, we will not be able to detect other risk items.)")
    public String getIsOpenSource() {
        return this.isOpenSource;
    }

    public void setIsOpenSource(String isOpenSource) {
        this.isOpenSource = isOpenSource;
    }

    public ResponseWrapperTokenSecurityResult sellTax(String sellTax) {
        this.sellTax = sellTax;
        return this;
    }

    @Schema(description="It describes the tax when selling the token.  Example: \"sell_tax\": 0.1%.  No return means unknown.(Notice:(1) When \"is_in_dex\": \"0\", there will be no return.  (2) Sell tax will cause the actual value received when selling a token to be less than expected, and too much buy tax may lead to large losses. (3) When \"sell_tax\": \"1\", it means sell-tax is 100% or this token cannot be sold. (4) Sometimes token's  trading-cool-down mechanism would affect our sandbox system. When \"trading_cooldown\": \"1\", \"sell_tax\" may return \"1\".)")
    public String getSellTax() {
        return this.sellTax;
    }

    public void setSellTax(String sellTax) {
        this.sellTax = sellTax;
    }

    public ResponseWrapperTokenSecurityResult tokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @Schema(description="Token Name")
    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public ResponseWrapperTokenSecurityResult creatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
        return this;
    }

    @Schema(description="It describes this contract's owner address.  Example: \"creator_address\": \"0x744aF9cBb7606BB040f6FBf1c0a0B0dcBA6385E5\";")
    public String getCreatorAddress() {
        return this.creatorAddress;
    }

    public void setCreatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
    }

    public ResponseWrapperTokenSecurityResult creatorPercent(String creatorPercent) {
        this.creatorPercent = creatorPercent;
        return this;
    }

    @Schema(description="It describes the percentage of tokens held by the contract owner. Example:\"owner_balance\": 0.1.(Notice:1 means 100% here.)")
    public String getCreatorPercent() {
        return this.creatorPercent;
    }

    public void setCreatorPercent(String creatorPercent) {
        this.creatorPercent = creatorPercent;
    }

    public ResponseWrapperTokenSecurityResult isProxy(String isProxy) {
        this.isProxy = isProxy;
        return this;
    }

    @Schema(description="It describes whether this contract has a proxy contract.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Most Proxy contracts are accompanied by modifiable implementation contracts, and implementation contracts may contain significant potential risk. When the contract is a Proxy, we will stop detecting other risk items.)")
    public String getIsProxy() {
        return this.isProxy;
    }

    public void setIsProxy(String isProxy) {
        this.isProxy = isProxy;
    }

    public ResponseWrapperTokenSecurityResult creatorBalance(String creatorBalance) {
        this.creatorBalance = creatorBalance;
        return this;
    }

    @Schema(description="It describes the balance of the contract owner.  Example:\"owner_balance\": 100000000.")
    public String getCreatorBalance() {
        return this.creatorBalance;
    }

    public void setCreatorBalance(String creatorBalance) {
        this.creatorBalance = creatorBalance;
    }

    public ResponseWrapperTokenSecurityResult isInDex(String isInDex) {
        this.isInDex = isInDex;
        return this;
    }

    @Schema(description="It describes whether the token can be traded on the main Dex. \"1\" means true; \"0\" means false(Notice:It only counts when the token has a marketing pair with mainstream coins/tokens.)")
    public String getIsInDex() {
        return this.isInDex;
    }

    public void setIsInDex(String isInDex) {
        this.isInDex = isInDex;
    }

    public ResponseWrapperTokenSecurityResult ownerBalance(String ownerBalance) {
        this.ownerBalance = ownerBalance;
        return this;
    }

    @Schema(description="It describes the balance of the contract owner.  Example: \"owner_balance\": \"100000000\".  No return or return empty means there is no ownership or can't find ownership.(Notice:When \"owner_address\" returns empty, or no return, there will be no return.)")
    public String getOwnerBalance() {
        return this.ownerBalance;
    }

    public void setOwnerBalance(String ownerBalance) {
        this.ownerBalance = ownerBalance;
    }

    public ResponseWrapperTokenSecurityResult totalSupply(String totalSupply) {
        this.totalSupply = totalSupply;
        return this;
    }

    @Schema(description="It describes the supply number of the token. Example:\"total_supply\": 100000000")
    public String getTotalSupply() {
        return this.totalSupply;
    }

    public void setTotalSupply(String totalSupply) {
        this.totalSupply = totalSupply;
    }

    public ResponseWrapperTokenSecurityResult isTrueToken(String isTrueToken) {
        this.isTrueToken = isTrueToken;
        return this;
    }

    @Schema(description="It describes whether the token is true or fake. \"1\" means true token; \"0\" means fake token; None means no result (Because we did not find decisive information about the truth or falsity)(Notice:Only \"is_true_token\": \"0\" means it is a fake token.)")
    public String getIsTrueToken() {
        return this.isTrueToken;
    }

    public void setIsTrueToken(String isTrueToken) {
        this.isTrueToken = isTrueToken;
    }

    public ResponseWrapperTokenSecurityResult canTakeBackOwnership(String canTakeBackOwnership) {
        this.canTakeBackOwnership = canTakeBackOwnership;
        return this;
    }

    @Schema(description="It describes whether this contract has the function to take back ownership.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Ownership is mostly used to adjust the parameters and status of the contract, such as minting, modification of slippage, suspension of trading, setting blacklsit, etc.  When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, these functions will most likely be disabled.)")
    public String getCanTakeBackOwnership() {
        return this.canTakeBackOwnership;
    }

    public void setCanTakeBackOwnership(String canTakeBackOwnership) {
        this.canTakeBackOwnership = canTakeBackOwnership;
    }

    public ResponseWrapperTokenSecurityResult isBlacklisted(String isBlacklisted) {
        this.isBlacklisted = isBlacklisted;
        return this;
    }

    @Schema(description="It describes whether the blacklist function is not included in the contract. If there is a blacklist, some addresses may not be able to trade normally. \"1\" means true; \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\",  there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) The contract owner may add any address into the blacklist, and the token holder in blacklist will not be able to trade. Abuse of the blacklist function will lead to great risks.  (4) For contracts without an owner (or the owner is a black hole address), the blacklist will not be able to get updated. However, the existing blacklist is still in effect.)")
    public String getIsBlacklisted() {
        return this.isBlacklisted;
    }

    public void setIsBlacklisted(String isBlacklisted) {
        this.isBlacklisted = isBlacklisted;
    }

    public ResponseWrapperTokenSecurityResult ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    @Schema(description="It describes this contract's owner address.  Example: \"owner_address\": \"0x744aF9cBb7606BB040f6FBf1c0a0B0dcBA6385E5\";  No return means unknown; Return empty means there is no ownership or can't find ownership.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Ownership is mostly used to adjust the parameters and status of the contract, such as minting, modification of slippage, suspension of trading, setting blacklist, etc.  When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, these functions will most likely be disabled.)")
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public ResponseWrapperTokenSecurityResult slippageModifiable(String slippageModifiable) {
        this.slippageModifiable = slippageModifiable;
        return this;
    }

    @Schema(description="It describes whether the trading tax can be modifiable by token contract. \"1\" means true; \"0\" means false; No return means unknown.(Notice:(1) When When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Token with modifiable tax means that the contract owner can modify the buy tax or sell tax of the token. This may cause some losses, especially since some contracts have unlimited modifiable tax rates, which would make the token untradeable.  (4) This function generally relies on ownership. When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, this function will most likely be disabled.)")
    public String getSlippageModifiable() {
        return this.slippageModifiable;
    }

    public void setSlippageModifiable(String slippageModifiable) {
        this.slippageModifiable = slippageModifiable;
    }

    public ResponseWrapperTokenSecurityResult buyTax(String buyTax) {
        this.buyTax = buyTax;
        return this;
    }

    @Schema(description="It describes the tax when buying the token.  Example: \"buy_tax\": 0.1%.  No return means unknown.(Notice:(1) When \"is_in_dex\": \"0\", there will be no return.  (2) Buy tax will cause the actual value received when buying a token to be less than expected, and too much buy tax may lead to heavy losses. (3) When \"buy_tax\": \"1\", it means buy tax is 100% or cannot buy. (4) Sometimes token's anti-bot mechanism would affect our sandbox system, leading to \"cannoy_buy\": \"1\",  causing the display of \"buy_tax\": \"1\". (5)Some of the token is deisgned not for sale, leading to \"cannot_buy\":1, causing the display of \"buy_tax\": \"1\".)")
    public String getBuyTax() {
        return this.buyTax;
    }

    public void setBuyTax(String buyTax) {
        this.buyTax = buyTax;
    }

    public ResponseWrapperTokenSecurityResult externalCall(String externalCall) {
        this.externalCall = externalCall;
        return this;
    }

    @Schema(description="It describes whether the contract would call functions of other contracts when primary methods are executed. \"1\" means true;  \"0\" means false; No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) External call would cause the implementation of this contract to be highly dependent on other external contracts, which may be a potential risk.)")
    public String getExternalCall() {
        return this.externalCall;
    }

    public void setExternalCall(String externalCall) {
        this.externalCall = externalCall;
    }

    public ResponseWrapperTokenSecurityResult cannotSellAll(String cannotSellAll) {
        this.cannotSellAll = cannotSellAll;
        return this;
    }

    @Schema(description="It describes whether the contract has the function restricting token holder selling all the token.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_in_dex\": \"0\", there will be no return.  (2) This feature means that you will not be able to sell all your tokens in a single sale. Sometimes you need to leave a certain percentage of the token, e.g. 10%, sometimes you need to leave a fixed number of token, such as 10 token. (3) When \"buy_tax\": \"1\", there will be no return.)")
    public String getCannotSellAll() {
        return this.cannotSellAll;
    }

    public void setCannotSellAll(String cannotSellAll) {
        this.cannotSellAll = cannotSellAll;
    }

    public ResponseWrapperTokenSecurityResult lpHolderCount(String lpHolderCount) {
        this.lpHolderCount = lpHolderCount;
        return this;
    }

    @Schema(description="It describes the number of LP token holders. Example:\"lp_holder_count\": \"4342\". No return means no LP.(Notice:When \"is_in_dex\": \"0\", there will be no return.)")
    public String getLpHolderCount() {
        return this.lpHolderCount;
    }

    public void setLpHolderCount(String lpHolderCount) {
        this.lpHolderCount = lpHolderCount;
    }

    public ResponseWrapperTokenSecurityResult personalSlippageModifiable(String personalSlippageModifiable) {
        this.personalSlippageModifiable = personalSlippageModifiable;
        return this;
    }

    @Schema(description="It describes whether the owner can set a different tax rate for every assigned address. \"1\" means ture; \"0\" means false; No return means unknown.(Notice:(1) When \"is_open_source\": \"0\",  there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) The contract owner may set a very outrageous tax rate for assigned address to block it from trading. Abuse of this funtcion will lead to great risks.  (4) For contracts without an owner (or the owner is a black hole address), this function would not able to be used. However, the existing tax rate would be still in effect.)")
    public String getPersonalSlippageModifiable() {
        return this.personalSlippageModifiable;
    }

    public void setPersonalSlippageModifiable(String personalSlippageModifiable) {
        this.personalSlippageModifiable = personalSlippageModifiable;
    }

    public ResponseWrapperTokenSecurityResult isAntiWhale(String isAntiWhale) {
        this.isAntiWhale = isAntiWhale;
        return this;
    }

    @Schema(description="It describes whether the contract has the function to limit the maximum amount of transactions or the maximum token position that for single address.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return. (2) Sometimes, when \"is_proxy\": \"1\", there will be no return. )")
    public String getIsAntiWhale() {
        return this.isAntiWhale;
    }

    public void setIsAntiWhale(String isAntiWhale) {
        this.isAntiWhale = isAntiWhale;
    }

    public ResponseWrapperTokenSecurityResult isMintable(String isMintable) {
        this.isMintable = isMintable;
        return this;
    }

    @Schema(description="It describes whether this contract has the function to mint tokens.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Mint function will directly trigger a massive sell-off, causing the coin price to plummet. It is extremely risky.  (4) This function generally relies on ownership. When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, this function will most likely be disabled.)")
    public String getIsMintable() {
        return this.isMintable;
    }

    public void setIsMintable(String isMintable) {
        this.isMintable = isMintable;
    }

    public ResponseWrapperTokenSecurityResult ownerChangeBalance(String ownerChangeBalance) {
        this.ownerChangeBalance = ownerChangeBalance;
        return this;
    }

    @Schema(description="It describes whether the contract owner has the authority to change the balance of any token holder.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return.  (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3) Token with this feature means that the owner can modify anyone's balance, resulting in an asset straight to zero or a massive minting and sell-off.  (4) This function generally relies on ownership. When the contract does not have an owner (or if the owner is a black hole address) and the owner cannot be retrieved, this function will most likely be disabled.)")
    public String getOwnerChangeBalance() {
        return this.ownerChangeBalance;
    }

    public void setOwnerChangeBalance(String ownerChangeBalance) {
        this.ownerChangeBalance = ownerChangeBalance;
    }

    public ResponseWrapperTokenSecurityResult cannotBuy(String cannotBuy) {
        this.cannotBuy = cannotBuy;
        return this;
    }

    @Schema(description="It deiscribes whether the Token can be bought. \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) Generally, \"cannot_buy\": \"1\" would be found in Reward Tokens. Such Tokens are issued as rewards for some on-chain applications and cannot be bought directly by users. (2) Sometimes token's anti-bot mechanism would affect our sandbox system, causing the display of \"buy_tax\": \"1\". (3) When \u201ccannot_buy\u201d: \"1\", our sandbox system might be bloked, causing the display of \"buy_tax\": \"1\" and \"sell_tax\": \"1\")")
    public String getCannotBuy() {
        return this.cannotBuy;
    }

    public void setCannotBuy(String cannotBuy) {
        this.cannotBuy = cannotBuy;
    }

    public ResponseWrapperTokenSecurityResult antiWhaleModifiable(String antiWhaleModifiable) {
        this.antiWhaleModifiable = antiWhaleModifiable;
        return this;
    }

    @Schema(description="It describes whether the contract has the function to modify the maximum amount of transactions or the maximum token position.  \"1\" means true;  \"0\" means false;  No return means unknown.(Notice:(1) When \"is_open_source\": \"0\", there will be no return. (2) Sometimes, when \"is_proxy\": \"1\", there will be no return.  (3)When the anti whale value is set to a very small value, all tradinge would fail.)")
    public String getAntiWhaleModifiable() {
        return this.antiWhaleModifiable;
    }

    public void setAntiWhaleModifiable(String antiWhaleModifiable) {
        this.antiWhaleModifiable = antiWhaleModifiable;
    }

    public ResponseWrapperTokenSecurityResult tokenSymbol(String tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
        return this;
    }

    @Schema(description="Token Symbol")
    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public void setTokenSymbol(String tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseWrapperTokenSecurityResult responseWrapperTokenSecurityResult = (ResponseWrapperTokenSecurityResult)o;
        return Objects.equals(this.note, responseWrapperTokenSecurityResult.note) && Objects.equals(this.lpTotalSupply, responseWrapperTokenSecurityResult.lpTotalSupply) && Objects.equals(this.lpHolders, responseWrapperTokenSecurityResult.lpHolders) && Objects.equals(this.isAirdropScam, responseWrapperTokenSecurityResult.isAirdropScam) && Objects.equals(this.otherPotentialRisks, responseWrapperTokenSecurityResult.otherPotentialRisks) && Objects.equals(this.transferPausable, responseWrapperTokenSecurityResult.transferPausable) && Objects.equals(this.tradingCooldown, responseWrapperTokenSecurityResult.tradingCooldown) && Objects.equals(this.hiddenOwner, responseWrapperTokenSecurityResult.hiddenOwner) && Objects.equals(this.selfdestruct, responseWrapperTokenSecurityResult.selfdestruct) && Objects.equals(this.ownerPercent, responseWrapperTokenSecurityResult.ownerPercent) && Objects.equals(this.isWhitelisted, responseWrapperTokenSecurityResult.isWhitelisted) && Objects.equals(this.holderCount, responseWrapperTokenSecurityResult.holderCount) && Objects.equals(this.trustList, responseWrapperTokenSecurityResult.trustList) && Objects.equals(this.isHoneypot, responseWrapperTokenSecurityResult.isHoneypot) && Objects.equals(this.holders, responseWrapperTokenSecurityResult.holders) && Objects.equals(this.dex, responseWrapperTokenSecurityResult.dex) && Objects.equals(this.isOpenSource, responseWrapperTokenSecurityResult.isOpenSource) && Objects.equals(this.sellTax, responseWrapperTokenSecurityResult.sellTax) && Objects.equals(this.tokenName, responseWrapperTokenSecurityResult.tokenName) && Objects.equals(this.creatorAddress, responseWrapperTokenSecurityResult.creatorAddress) && Objects.equals(this.creatorPercent, responseWrapperTokenSecurityResult.creatorPercent) && Objects.equals(this.isProxy, responseWrapperTokenSecurityResult.isProxy) && Objects.equals(this.creatorBalance, responseWrapperTokenSecurityResult.creatorBalance) && Objects.equals(this.isInDex, responseWrapperTokenSecurityResult.isInDex) && Objects.equals(this.ownerBalance, responseWrapperTokenSecurityResult.ownerBalance) && Objects.equals(this.totalSupply, responseWrapperTokenSecurityResult.totalSupply) && Objects.equals(this.isTrueToken, responseWrapperTokenSecurityResult.isTrueToken) && Objects.equals(this.canTakeBackOwnership, responseWrapperTokenSecurityResult.canTakeBackOwnership) && Objects.equals(this.isBlacklisted, responseWrapperTokenSecurityResult.isBlacklisted) && Objects.equals(this.ownerAddress, responseWrapperTokenSecurityResult.ownerAddress) && Objects.equals(this.slippageModifiable, responseWrapperTokenSecurityResult.slippageModifiable) && Objects.equals(this.buyTax, responseWrapperTokenSecurityResult.buyTax) && Objects.equals(this.externalCall, responseWrapperTokenSecurityResult.externalCall) && Objects.equals(this.cannotSellAll, responseWrapperTokenSecurityResult.cannotSellAll) && Objects.equals(this.lpHolderCount, responseWrapperTokenSecurityResult.lpHolderCount) && Objects.equals(this.personalSlippageModifiable, responseWrapperTokenSecurityResult.personalSlippageModifiable) && Objects.equals(this.isAntiWhale, responseWrapperTokenSecurityResult.isAntiWhale) && Objects.equals(this.isMintable, responseWrapperTokenSecurityResult.isMintable) && Objects.equals(this.ownerChangeBalance, responseWrapperTokenSecurityResult.ownerChangeBalance) && Objects.equals(this.cannotBuy, responseWrapperTokenSecurityResult.cannotBuy) && Objects.equals(this.antiWhaleModifiable, responseWrapperTokenSecurityResult.antiWhaleModifiable) && Objects.equals(this.tokenSymbol, responseWrapperTokenSecurityResult.tokenSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.note, this.lpTotalSupply, this.lpHolders, this.isAirdropScam, this.otherPotentialRisks, this.transferPausable, this.tradingCooldown, this.hiddenOwner, this.selfdestruct, this.ownerPercent, this.isWhitelisted, this.holderCount, this.trustList, this.isHoneypot, this.holders, this.dex, this.isOpenSource, this.sellTax, this.tokenName, this.creatorAddress, this.creatorPercent, this.isProxy, this.creatorBalance, this.isInDex, this.ownerBalance, this.totalSupply, this.isTrueToken, this.canTakeBackOwnership, this.isBlacklisted, this.ownerAddress, this.slippageModifiable, this.buyTax, this.externalCall, this.cannotSellAll, this.lpHolderCount, this.personalSlippageModifiable, this.isAntiWhale, this.isMintable, this.ownerChangeBalance, this.cannotBuy, this.antiWhaleModifiable, this.tokenSymbol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseWrapperTokenSecurityResult {\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    lpTotalSupply: ").append(this.toIndentedString(this.lpTotalSupply)).append("\n");
        sb.append("    lpHolders: ").append(this.toIndentedString(this.lpHolders)).append("\n");
        sb.append("    isAirdropScam: ").append(this.toIndentedString(this.isAirdropScam)).append("\n");
        sb.append("    otherPotentialRisks: ").append(this.toIndentedString(this.otherPotentialRisks)).append("\n");
        sb.append("    transferPausable: ").append(this.toIndentedString(this.transferPausable)).append("\n");
        sb.append("    tradingCooldown: ").append(this.toIndentedString(this.tradingCooldown)).append("\n");
        sb.append("    hiddenOwner: ").append(this.toIndentedString(this.hiddenOwner)).append("\n");
        sb.append("    selfdestruct: ").append(this.toIndentedString(this.selfdestruct)).append("\n");
        sb.append("    ownerPercent: ").append(this.toIndentedString(this.ownerPercent)).append("\n");
        sb.append("    isWhitelisted: ").append(this.toIndentedString(this.isWhitelisted)).append("\n");
        sb.append("    holderCount: ").append(this.toIndentedString(this.holderCount)).append("\n");
        sb.append("    trustList: ").append(this.toIndentedString(this.trustList)).append("\n");
        sb.append("    isHoneypot: ").append(this.toIndentedString(this.isHoneypot)).append("\n");
        sb.append("    holders: ").append(this.toIndentedString(this.holders)).append("\n");
        sb.append("    dex: ").append(this.toIndentedString(this.dex)).append("\n");
        sb.append("    isOpenSource: ").append(this.toIndentedString(this.isOpenSource)).append("\n");
        sb.append("    sellTax: ").append(this.toIndentedString(this.sellTax)).append("\n");
        sb.append("    tokenName: ").append(this.toIndentedString(this.tokenName)).append("\n");
        sb.append("    creatorAddress: ").append(this.toIndentedString(this.creatorAddress)).append("\n");
        sb.append("    creatorPercent: ").append(this.toIndentedString(this.creatorPercent)).append("\n");
        sb.append("    isProxy: ").append(this.toIndentedString(this.isProxy)).append("\n");
        sb.append("    creatorBalance: ").append(this.toIndentedString(this.creatorBalance)).append("\n");
        sb.append("    isInDex: ").append(this.toIndentedString(this.isInDex)).append("\n");
        sb.append("    ownerBalance: ").append(this.toIndentedString(this.ownerBalance)).append("\n");
        sb.append("    totalSupply: ").append(this.toIndentedString(this.totalSupply)).append("\n");
        sb.append("    isTrueToken: ").append(this.toIndentedString(this.isTrueToken)).append("\n");
        sb.append("    canTakeBackOwnership: ").append(this.toIndentedString(this.canTakeBackOwnership)).append("\n");
        sb.append("    isBlacklisted: ").append(this.toIndentedString(this.isBlacklisted)).append("\n");
        sb.append("    ownerAddress: ").append(this.toIndentedString(this.ownerAddress)).append("\n");
        sb.append("    slippageModifiable: ").append(this.toIndentedString(this.slippageModifiable)).append("\n");
        sb.append("    buyTax: ").append(this.toIndentedString(this.buyTax)).append("\n");
        sb.append("    externalCall: ").append(this.toIndentedString(this.externalCall)).append("\n");
        sb.append("    cannotSellAll: ").append(this.toIndentedString(this.cannotSellAll)).append("\n");
        sb.append("    lpHolderCount: ").append(this.toIndentedString(this.lpHolderCount)).append("\n");
        sb.append("    personalSlippageModifiable: ").append(this.toIndentedString(this.personalSlippageModifiable)).append("\n");
        sb.append("    isAntiWhale: ").append(this.toIndentedString(this.isAntiWhale)).append("\n");
        sb.append("    isMintable: ").append(this.toIndentedString(this.isMintable)).append("\n");
        sb.append("    ownerChangeBalance: ").append(this.toIndentedString(this.ownerChangeBalance)).append("\n");
        sb.append("    cannotBuy: ").append(this.toIndentedString(this.cannotBuy)).append("\n");
        sb.append("    antiWhaleModifiable: ").append(this.toIndentedString(this.antiWhaleModifiable)).append("\n");
        sb.append("    tokenSymbol: ").append(this.toIndentedString(this.tokenSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

