/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model.response;

import com.google.gson.annotations.SerializedName;
import io.gopluslabs.client.model.info.AbiParamInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ParseAbiDataResponse {
    @SerializedName(value="contract_description")
    private String contractDescription = null;
    @SerializedName(value="contract_name")
    private String contractName = null;
    @SerializedName(value="malicious_contract")
    private Integer maliciousContract = null;
    @SerializedName(value="method")
    private String method = null;
    @SerializedName(value="params")
    private List<AbiParamInfo> params = null;
    @SerializedName(value="risk")
    private String risk = null;
    @SerializedName(value="risky_signature")
    private Integer riskySignature = null;
    @SerializedName(value="signature_detail")
    private String signatureDetail = null;

    public ParseAbiDataResponse contractDescription(String contractDescription) {
        this.contractDescription = contractDescription;
        return this;
    }

    @Schema(description="Description of the contract.")
    public String getContractDescription() {
        return this.contractDescription;
    }

    public void setContractDescription(String contractDescription) {
        this.contractDescription = contractDescription;
    }

    public ParseAbiDataResponse contractName(String contractName) {
        this.contractName = contractName;
        return this;
    }

    @Schema(description="The name of the contract that the user is interacting with.")
    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public ParseAbiDataResponse maliciousContract(Integer maliciousContract) {
        this.maliciousContract = maliciousContract;
        return this;
    }

    @Schema(description="It tells if contract that the user is interacting with is malicious contract.")
    public Integer getMaliciousContract() {
        return this.maliciousContract;
    }

    public void setMaliciousContract(Integer maliciousContract) {
        this.maliciousContract = maliciousContract;
    }

    public ParseAbiDataResponse method(String method) {
        this.method = method;
        return this;
    }

    @Schema(description="It describes the method name in ABI, for example \"transfer\".")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public ParseAbiDataResponse params(List<AbiParamInfo> params) {
        this.params = params;
        return this;
    }

    public ParseAbiDataResponse addParamsItem(AbiParamInfo paramsItem) {
        if (this.params == null) {
            this.params = new ArrayList<AbiParamInfo>();
        }
        this.params.add(paramsItem);
        return this;
    }

    @Schema(description="It describes the parameter info")
    public List<AbiParamInfo> getParams() {
        return this.params;
    }

    public void setParams(List<AbiParamInfo> params) {
        this.params = params;
    }

    public ParseAbiDataResponse risk(String risk) {
        this.risk = risk;
        return this;
    }

    @Schema(description="It explains why the transaction that users are signing contains risk.(Notice:Even non-malicious, commonly used, well-known contracts can be highly risky if not used properly.)")
    public String getRisk() {
        return this.risk;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public ParseAbiDataResponse riskySignature(Integer riskySignature) {
        this.riskySignature = riskySignature;
        return this;
    }

    @Schema(description="It tells if the transaction that users are signing contains risk.(Notice:Even non-malicious, commonly used, well-known contracts can be highly risky if not used properly.)")
    public Integer getRiskySignature() {
        return this.riskySignature;
    }

    public void setRiskySignature(Integer riskySignature) {
        this.riskySignature = riskySignature;
    }

    public ParseAbiDataResponse signatureDetail(String signatureDetail) {
        this.signatureDetail = signatureDetail;
        return this;
    }

    @Schema(description="It explain the function of the method")
    public String getSignatureDetail() {
        return this.signatureDetail;
    }

    public void setSignatureDetail(String signatureDetail) {
        this.signatureDetail = signatureDetail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseAbiDataResponse parseAbiDataResponse = (ParseAbiDataResponse)o;
        return Objects.equals(this.contractDescription, parseAbiDataResponse.contractDescription) && Objects.equals(this.contractName, parseAbiDataResponse.contractName) && Objects.equals(this.maliciousContract, parseAbiDataResponse.maliciousContract) && Objects.equals(this.method, parseAbiDataResponse.method) && Objects.equals(this.params, parseAbiDataResponse.params) && Objects.equals(this.risk, parseAbiDataResponse.risk) && Objects.equals(this.riskySignature, parseAbiDataResponse.riskySignature) && Objects.equals(this.signatureDetail, parseAbiDataResponse.signatureDetail);
    }

    public int hashCode() {
        return Objects.hash(this.contractDescription, this.contractName, this.maliciousContract, this.method, this.params, this.risk, this.riskySignature, this.signatureDetail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParseAbiDataResponse {\n");
        sb.append("    contractDescription: ").append(this.toIndentedString(this.contractDescription)).append("\n");
        sb.append("    contractName: ").append(this.toIndentedString(this.contractName)).append("\n");
        sb.append("    maliciousContract: ").append(this.toIndentedString(this.maliciousContract)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    risk: ").append(this.toIndentedString(this.risk)).append("\n");
        sb.append("    riskySignature: ").append(this.toIndentedString(this.riskySignature)).append("\n");
        sb.append("    signatureDetail: ").append(this.toIndentedString(this.signatureDetail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

