/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gopluslabs.client.common.ApiCallback;
import io.gopluslabs.client.common.ApiClient;
import io.gopluslabs.client.common.ApiException;
import io.gopluslabs.client.common.ApiResponse;
import io.gopluslabs.client.common.config.Configuration;
import io.gopluslabs.client.common.progress.ProgressRequestBody;
import io.gopluslabs.client.common.progress.ProgressResponseBody;
import io.gopluslabs.client.common.utils.Pair;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperGetDefiInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class DefiControllerApi {
    private ApiClient apiClient;

    public DefiControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefiControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getDefiInfoUsingGETCall(String contractAddresses, String chainId, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/rugpull_detecting/{chain_id}".replaceAll("\\{chain_id\\}", this.apiClient.escapeString(chainId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contract_addresses", contractAddresses));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDefiInfoUsingGETValidateBeforeCall(String contractAddresses, String chainId, String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling getDefiInfoUsingGET(Async)");
        }
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling getDefiInfoUsingGET(Async)");
        }
        Call call = this.getDefiInfoUsingGETCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperGetDefiInfo getDefiInfoUsingGET(String contractAddresses, String chainId, String authorization, Integer timeOut) throws ApiException {
        Optional.ofNullable(timeOut).ifPresent(this.apiClient::setReadTimeout);
        ApiResponse<ResponseWrapperGetDefiInfo> resp = this.getDefiInfoUsingGETWithHttpInfo(contractAddresses, chainId, authorization);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperGetDefiInfo> getDefiInfoUsingGETWithHttpInfo(String contractAddresses, String chainId, String authorization) throws ApiException {
        Call call = this.getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetDefiInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDefiInfoUsingGETAsync(String contractAddresses, String chainId, String authorization, final ApiCallback<ResponseWrapperGetDefiInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetDefiInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

