/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model.entity;

import com.google.gson.annotations.SerializedName;
import io.gopluslabs.client.model.entity.Contracts;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContractsSecurity {
    @SerializedName(value="chain_id")
    private String chainId = null;
    @SerializedName(value="contracts")
    private List<Contracts> contracts = null;

    public ContractsSecurity chainId(String chainId) {
        this.chainId = chainId;
        return this;
    }

    @Schema(description="It describes the chains that contracts are deployed on;\"1\" means Ethereum; \"25\" means Cronos; \"56\" means BSC; \"128\" means HECO; \"137\" means Polygon; \"250\" means Fantom; \"42161\" means Arbitrum; \"43114\" means Avalanche.")
    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ContractsSecurity contracts(List<Contracts> contracts) {
        this.contracts = contracts;
        return this;
    }

    public ContractsSecurity addContractsItem(Contracts contractsItem) {
        if (this.contracts == null) {
            this.contracts = new ArrayList<Contracts>();
        }
        this.contracts.add(contractsItem);
        return this;
    }

    @Schema(description="contract info")
    public List<Contracts> getContracts() {
        return this.contracts;
    }

    public void setContracts(List<Contracts> contracts) {
        this.contracts = contracts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractsSecurity contractsSecurity = (ContractsSecurity)o;
        return Objects.equals(this.chainId, contractsSecurity.chainId) && Objects.equals(this.contracts, contractsSecurity.contracts);
    }

    public int hashCode() {
        return Objects.hash(this.chainId, this.contracts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractsSecurity {\n");
        sb.append("    chainId: ").append(this.toIndentedString(this.chainId)).append("\n");
        sb.append("    contracts: ").append(this.toIndentedString(this.contracts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

