/*
 * GoPlus Security API Document
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package io.gopluslabs.client.api
        ;

import com.google.gson.reflect.TypeToken;
import io.gopluslabs.client.common.ApiCallback;
import io.gopluslabs.client.common.ApiClient;
import io.gopluslabs.client.common.ApiException;
import io.gopluslabs.client.common.ApiResponse;
import io.gopluslabs.client.common.config.Configuration;
import io.gopluslabs.client.common.progress.ProgressRequestBody;
import io.gopluslabs.client.common.progress.ProgressResponseBody;
import io.gopluslabs.client.common.utils.Pair;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperGetDefiInfo;


import java.io.IOException;
import java.lang.reflect.Type;

import java.util.*;

public class DefiControllerApi {
    private ApiClient apiClient;

    public DefiControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefiControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getDefiInfoUsingGET
     *
     * @param contractAddresses       Defi protocol address (required)
     * @param chainId                 Chain id, (eth: 1, bsc: 56) (required)
     * @param authorization           Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDefiInfoUsingGETCall(String contractAddresses, String chainId, String authorization, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/rugpull_detecting/{chain_id}"
                .replaceAll("\\{" + "chain_id" + "\\}", apiClient.escapeString(chainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("contract_addresses", contractAddresses));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null)
            localVarHeaderParams.put("Authorization", apiClient.parameterToString(authorization));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "*/*"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDefiInfoUsingGETValidateBeforeCall(String contractAddresses, String chainId, String authorization, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'contractAddresses' is set
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling getDefiInfoUsingGET(Async)");
        }
        // verify the required parameter 'chainId' is set
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling getDefiInfoUsingGET(Async)");
        }

        com.squareup.okhttp.Call call = getDefiInfoUsingGETCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        return call;


    }

    /**
     * Rug-pull Detection API Beta
     *
     * @param contractAddresses Defi protocol address (required)
     * @param chainId           Chain id, (eth: 1, bsc: 56) (required)
     * @param authorization     Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param timeOut           (optional)
     * @return ResponseWrapperGetDefiInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ResponseWrapperGetDefiInfo getDefiInfoUsingGET(String contractAddresses, String chainId, String authorization, Integer timeOut) throws ApiException {
        Optional.ofNullable(timeOut).ifPresent(apiClient::setReadTimeout);
        ApiResponse<ResponseWrapperGetDefiInfo> resp = getDefiInfoUsingGETWithHttpInfo(contractAddresses, chainId, authorization);
        return resp.getData();
    }

    /**
     * Rug-pull Detection API Beta
     *
     * @param contractAddresses Defi protocol address (required)
     * @param chainId           Chain id, (eth: 1, bsc: 56) (required)
     * @param authorization     Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @return ApiResponse&lt;ResponseWrapperGetDefiInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ResponseWrapperGetDefiInfo> getDefiInfoUsingGETWithHttpInfo(String contractAddresses, String chainId, String authorization) throws ApiException {
        com.squareup.okhttp.Call call = getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetDefiInfo>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Rug-pull Detection API Beta (asynchronously)
     *
     * @param contractAddresses Defi protocol address (required)
     * @param chainId           Chain id, (eth: 1, bsc: 56) (required)
     * @param authorization     Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param callback          The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDefiInfoUsingGETAsync(String contractAddresses, String chainId, String authorization, final ApiCallback<ResponseWrapperGetDefiInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetDefiInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
