/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gopluslabs.client.common.ApiCallback;
import io.gopluslabs.client.common.ApiClient;
import io.gopluslabs.client.common.ApiException;
import io.gopluslabs.client.common.ApiResponse;
import io.gopluslabs.client.common.config.Configuration;
import io.gopluslabs.client.common.progress.ProgressRequestBody;
import io.gopluslabs.client.common.progress.ProgressResponseBody;
import io.gopluslabs.client.common.utils.Pair;
import io.gopluslabs.client.model.request.GetAccessTokenRequest;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperGetAccessTokenResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class TokenControllerApi {
    private ApiClient apiClient;

    public TokenControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAccessTokenUsingPOSTCall(GetAccessTokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GetAccessTokenRequest localVarPostBody = body;
        String localVarPath = "/api/v1/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAccessTokenUsingPOSTValidateBeforeCall(GetAccessTokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAccessTokenUsingPOSTCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperGetAccessTokenResponse getAccessTokenUsingPOST(GetAccessTokenRequest body, Integer timeOut) throws ApiException {
        Optional.ofNullable(timeOut).ifPresent(this.apiClient::setReadTimeout);
        ApiResponse<ResponseWrapperGetAccessTokenResponse> resp = this.getAccessTokenUsingPOSTWithHttpInfo(body);
        return resp.getData();
    }

    private ApiResponse<ResponseWrapperGetAccessTokenResponse> getAccessTokenUsingPOSTWithHttpInfo(GetAccessTokenRequest body) throws ApiException {
        Call call = this.getAccessTokenUsingPOSTValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetAccessTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAccessTokenUsingPOSTAsync(GetAccessTokenRequest body, final ApiCallback<ResponseWrapperGetAccessTokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAccessTokenUsingPOSTValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetAccessTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

