package io.gopluslabs.client.template;

import io.gopluslabs.client.api.*;
import io.gopluslabs.client.common.ApiException;
import io.gopluslabs.client.model.request.*;
import io.gopluslabs.client.model.responsewrapper.*;

public class GoPlusTemplate {

    /**
     * get token
     *
     * @param request request (optional)
     * @return ResponseWrapperGetAccessTokenResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperGetAccessTokenResponse getAccessToken(AccessTokenRequest request) throws ApiException {
        GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest();
        getAccessTokenRequest.setAppKey(request.getRequest().getAppKey());
        getAccessTokenRequest.setSign(request.getRequest().getSign());
        getAccessTokenRequest.setTime(request.getRequest().getTime());
        return new TokenControllerApi().getAccessTokenUsingPOST(getAccessTokenRequest, request.getTimeOut());
    }

    /**
     * Get the list of chains supported by different functions.
     *
     * @param request SupportedChainsRequest
     * @return ResponseWrapperListJSONObject
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperListJSONObject supportedChains(SupportedChainsRequest request) throws ApiException {
        return new TokenControllerV1Api().getChainsListUsingGET(
                request.getAuthorization(),
                request.getName(),
                request.getTimeOut()
        );
    }

    /**
     * Get token security and risk data.
     *
     * @param request TokenSecurityRequest
     * @return ResponseWrapperTokenSecurity
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperTokenSecurity tokenSecurity(TokenSecurityRequest request) throws ApiException {

        return new TokenControllerV1Api().tokenSecurityUsingGET1(
                request.getChainId(),
                request.getAddress(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }


    /**
     * Check if the address is malicious
     *
     * @param request AddressSecurityRequest
     * @return ResponseWrapperAddressContract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperAddressContract addressSecurity(AddressSecurityRequest request) throws ApiException {
        return new ApproveControllerV1Api().addressContractUsingGET1(
                request.getAddress(),
                request.getAuthorization(),
                request.getChainId(),
                request.getTimeOut()
        );
    }

    /**
     * Check if the approval is secure
     *
     * @param request ApprovalSecurityRequest
     * @return ResponseWrapperContractApproveResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperContractApproveResponse approvalSecurity(ApprovalSecurityRequest request) throws ApiException {
        return new ApproveControllerV1Api().approvalContractUsingGET(
                request.getChainId(),
                request.getAddress(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }


    /**
     * Check risk of all erc20 approvals under one EOA.
     *
     * @param request Erc20ApprovalSecurityRequest
     * @return ResponseWrapperListApproveTokenOutListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperListApproveTokenOutListResponse erc20ApprovalSecurity(Erc20ApprovalSecurityRequest request) throws ApiException {
        return new ApproveControllerV2Api().addressTokenApproveListUsingGET1(
                request.getAddress(),
                request.getChainId(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }

    /**
     * Check risk of all erc721 approvals under one EOA.
     *
     * @param request Erc721ApprovalSecurityRequest
     * @return ResponseWrapperListApproveNFTListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperListApproveNFTListResponse erc721ApprovalSecurity(Erc721ApprovalSecurityRequest request) throws ApiException {
        return new ApproveControllerV2Api().addressNFT721ApproveListUsingGET1(
                request.getAddress(),
                request.getChainId(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }


    /**
     * Check risk of all erc1155 approvals under one EOA.
     *
     * @param request Erc1155ApprovalSecurityRequest
     * @return ResponseWrapperListApproveNFT1155ListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperListApproveNFT1155ListResponse erc1155ApprovalSecurity(Erc1155ApprovalSecurityRequest request) throws ApiException {
        return new ApproveControllerV2Api().addressNFT1155ApproveListUsingGET1(
                request.getAddress(),
                request.getChainId(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }


    /**
     * Get abi decode info
     *
     * @param request InputDecodeRequest
     * @return ResponseWrapperParseAbiDataResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperParseAbiDataResponse inputDecode(InputDecodeRequest request) throws ApiException {
        ParseAbiDataRequest parseAbiDataRequest = new ParseAbiDataRequest();
        parseAbiDataRequest.setData(request.getBody().getData());
        parseAbiDataRequest.setChainId(request.getBody().getChainId());
        parseAbiDataRequest.setContractAddress(request.getBody().getContractAddress());

        return new ContractAbiControllerApi().getAbiDataInfoUsingPOST(
                parseAbiDataRequest,
                request.getAuthorization(),
                request.getTimeOut()
        );
    }


    /**
     * Get NFT security and risk data.
     *
     * @param request NftSecurityRequest
     * @return ResponseWrapperGetNftInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperGetNftInfo nftSecurity(NftSecurityRequest request) throws ApiException {
        return new NftControllerApi().getNftInfoUsingGET1(
                request.getChainId(),
                request.getAddress(),
                request.getAuthorization(),
                request.getTokenId(),
                request.getTimeOut()
        );
    }


    /**
     * Check risk of dapp through URL
     *
     * @param request DappSecurityRequest
     * @return ResponseWrapperDappContractSecurityResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperDappContractSecurityResponse dappSecurity(DappSecurityRequest request) throws ApiException {
        return new DappControllerApi().getDappInfoUsingGET(
                request.getAuthorization(),
                request.getUrl(),
                request.getTimeOut()
        );
    }


    /**
     * Check if the  url is a phishing site
     *
     * @param request PhishingSiteRequest
     * @return ResponseWrapperPhishingSite
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public static ResponseWrapperPhishingSite phishingSite(PhishingSiteRequest request) throws ApiException {
        return new WebsiteControllerApi().phishingSiteUsingGET(
                request.getUrl(),
                request.getAuthorization(),
                request.getTimeOut()
        );
    }
}
