/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model.info;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class AbiAddressInfo {
    @SerializedName(value="contract_name")
    private String contractName = null;
    @SerializedName(value="is_contract")
    private Integer isContract = null;
    @SerializedName(value="malicious_address")
    private Integer maliciousAddress = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="standard")
    private String standard = null;
    @SerializedName(value="symbol")
    private String symbol = null;

    public AbiAddressInfo contractName(String contractName) {
        this.contractName = contractName;
        return this;
    }

    @Schema(description="It describes the contract name if the address is a contract.")
    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public AbiAddressInfo isContract(Integer isContract) {
        this.isContract = isContract;
        return this;
    }

    @Schema(description="It describes whether the address is a contract. \"1\" means true; \"0\" means false.")
    public Integer getIsContract() {
        return this.isContract;
    }

    public void setIsContract(Integer isContract) {
        this.isContract = isContract;
    }

    public AbiAddressInfo maliciousAddress(Integer maliciousAddress) {
        this.maliciousAddress = maliciousAddress;
        return this;
    }

    @Schema(description="It describes whether the address is a suspected malicious contract.\"1\" means true; \"0\" means that we have not found malicious behavior of this address.")
    public Integer getMaliciousAddress() {
        return this.maliciousAddress;
    }

    public void setMaliciousAddress(Integer maliciousAddress) {
        this.maliciousAddress = maliciousAddress;
    }

    public AbiAddressInfo name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="It describes the token name if the address is an ERC20 contract.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbiAddressInfo standard(String standard) {
        this.standard = standard;
        return this;
    }

    @Schema(description="It describes the standard type of the contract.Example:\"erc20\".")
    public String getStandard() {
        return this.standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public AbiAddressInfo symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Schema(description="It describes the token symbol if the address is an ERC20 contract.")
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbiAddressInfo abiAddressInfo = (AbiAddressInfo)o;
        return Objects.equals(this.contractName, abiAddressInfo.contractName) && Objects.equals(this.isContract, abiAddressInfo.isContract) && Objects.equals(this.maliciousAddress, abiAddressInfo.maliciousAddress) && Objects.equals(this.name, abiAddressInfo.name) && Objects.equals(this.standard, abiAddressInfo.standard) && Objects.equals(this.symbol, abiAddressInfo.symbol);
    }

    public int hashCode() {
        return Objects.hash(this.contractName, this.isContract, this.maliciousAddress, this.name, this.standard, this.symbol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbiAddressInfo {\n");
        sb.append("    contractName: ").append(this.toIndentedString(this.contractName)).append("\n");
        sb.append("    isContract: ").append(this.toIndentedString(this.isContract)).append("\n");
        sb.append("    maliciousAddress: ").append(this.toIndentedString(this.maliciousAddress)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    standard: ").append(this.toIndentedString(this.standard)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

