/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gopluslabs.client.common.ApiCallback;
import io.gopluslabs.client.common.ApiClient;
import io.gopluslabs.client.common.ApiException;
import io.gopluslabs.client.common.ApiResponse;
import io.gopluslabs.client.common.config.Configuration;
import io.gopluslabs.client.common.progress.ProgressRequestBody;
import io.gopluslabs.client.common.progress.ProgressResponseBody;
import io.gopluslabs.client.common.utils.Pair;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperListJSONObject;
import io.gopluslabs.client.model.responsewrapper.ResponseWrapperTokenSecurity;
import io.gopluslabs.client.model.responsewrapper.deprecated.ResponseWrapperListJSONObject877c2b4f74b04546B8a06d6e416a60b5;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class TokenControllerV1Api {
    private ApiClient apiClient;

    public TokenControllerV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenControllerV1Api(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getChainsListUsingGETCall(String authorization, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/supported_chains";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChainsListUsingGETValidateBeforeCall(String authorization, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getChainsListUsingGETCall(authorization, name, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperListJSONObject getChainsListUsingGET(String authorization, String name, Integer timeOut) throws ApiException {
        Optional.ofNullable(timeOut).ifPresent(this.apiClient::setReadTimeout);
        ApiResponse<ResponseWrapperListJSONObject> resp = this.getChainsListUsingGETWithHttpInfo(authorization, name);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperListJSONObject> getChainsListUsingGETWithHttpInfo(String authorization, String name) throws ApiException {
        Call call = this.getChainsListUsingGETValidateBeforeCall(authorization, name, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperListJSONObject>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChainsListUsingGETAsync(String authorization, String name, final ApiCallback<ResponseWrapperListJSONObject877c2b4f74b04546B8a06d6e416a60b5> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChainsListUsingGETValidateBeforeCall(authorization, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperListJSONObject877c2b4f74b04546B8a06d6e416a60b5>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call tokenSecurityUsingGET1Call(String chainId, String contractAddresses, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/token_security/{chain_id}".replaceAll("\\{chain_id\\}", this.apiClient.escapeString(chainId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contract_addresses", contractAddresses));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tokenSecurityUsingGET1ValidateBeforeCall(String chainId, String contractAddresses, String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling tokenSecurityUsingGET1(Async)");
        }
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling tokenSecurityUsingGET1(Async)");
        }
        Call call = this.tokenSecurityUsingGET1Call(chainId, contractAddresses, authorization, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperTokenSecurity tokenSecurityUsingGET1(String chainId, String contractAddresses, String authorization, Integer timeOut) throws ApiException {
        Optional.ofNullable(timeOut).ifPresent(this.apiClient::setReadTimeout);
        ApiResponse<ResponseWrapperTokenSecurity> resp = this.tokenSecurityUsingGET1WithHttpInfo(chainId, contractAddresses, authorization);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperTokenSecurity> tokenSecurityUsingGET1WithHttpInfo(String chainId, String contractAddresses, String authorization) throws ApiException {
        Call call = this.tokenSecurityUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperTokenSecurity>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tokenSecurityUsingGET1Async(String chainId, String contractAddresses, String authorization, final ApiCallback<ResponseWrapperTokenSecurity> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tokenSecurityUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperTokenSecurity>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

