package io.gopluslabs.client.model.request;

public class NftSecurityRequest extends BaseRequest {


    private String chainId;
    private String address;
    private String tokenId;

    public static NftSecurityRequest of(String chainId, String address, String tokenId) {
        NftSecurityRequest request = new NftSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.tokenId = tokenId;
        return request;
    }
    public static NftSecurityRequest of(String chainId, String address, String tokenId, String authorization) {
        NftSecurityRequest request = new NftSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.tokenId = tokenId;
        request.authorization = authorization;
        return request;
    }

    public static NftSecurityRequest of(String chainId, String address, String tokenId, Integer timeOut) {
        NftSecurityRequest request = new NftSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.tokenId = tokenId;
        request.timeOut = timeOut;
        return request;
    }

    public static NftSecurityRequest of(String chainId, String address, String tokenId, String authorization, Integer timeOut) {
        NftSecurityRequest request = new NftSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.tokenId = tokenId;
        request.authorization = authorization;
        request.timeOut = timeOut;
        return request;
    }

    public String getChainId() {
        return chainId;
    }

    public String getAddress() {
        return address;
    }

    public String getTokenId() {
        return tokenId;
    }
}
