package io.gopluslabs.client.model.request;

public class AddressSecurityRequest extends BaseRequest {


    private String chainId;
    private String address;

    public static AddressSecurityRequest of(String chainId, String address) {
        AddressSecurityRequest request = new AddressSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        return request;
    }
    public static AddressSecurityRequest of(String chainId, String address, String authorization) {
        AddressSecurityRequest request = new AddressSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.authorization = authorization;
        return request;
    }

    public static AddressSecurityRequest of(String chainId, String address, Integer timeOut) {
        AddressSecurityRequest request = new AddressSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.timeOut = timeOut;
        return request;
    }

    public static AddressSecurityRequest of(String chainId, String address, String authorization, Integer timeOut) {
        AddressSecurityRequest request = new AddressSecurityRequest();
        request.chainId = chainId;
        request.address = address;
        request.authorization = authorization;
        request.timeOut = timeOut;
        return request;
    }

    public String getChainId() {
        return chainId;
    }

    public String getAddress() {
        return address;
    }
}
