/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import io.gopluslabs.client.ApiCallback;
import io.gopluslabs.client.ApiClient;
import io.gopluslabs.client.ApiException;
import io.gopluslabs.client.ApiResponse;
import io.gopluslabs.client.Configuration;
import io.gopluslabs.client.Pair;
import io.gopluslabs.client.ProgressRequestBody;
import io.gopluslabs.client.ProgressResponseBody;
import io.gopluslabs.client.model.GetDefiInfoResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DefiControllerApi {
    private ApiClient apiClient;

    public DefiControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefiControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getDefiInfoUsingGETCall(String contractAddresses, String chainId, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/rugpull_detecting/{chain_id}".replaceAll("\\{chain_id\\}", this.apiClient.escapeString(chainId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contract_addresses", contractAddresses));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDefiInfoUsingGETValidateBeforeCall(String contractAddresses, String chainId, String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling getDefiInfoUsingGET(Async)");
        }
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling getDefiInfoUsingGET(Async)");
        }
        Call call = this.getDefiInfoUsingGETCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        return call;
    }

    public GetDefiInfoResponse getDefiInfoUsingGET(String contractAddresses, String chainId, String authorization) throws ApiException {
        ApiResponse<GetDefiInfoResponse> resp = this.getDefiInfoUsingGETWithHttpInfo(contractAddresses, chainId, authorization);
        return resp.getData();
    }

    public ApiResponse<GetDefiInfoResponse> getDefiInfoUsingGETWithHttpInfo(String contractAddresses, String chainId, String authorization) throws ApiException {
        Call call = this.getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, null, null);
        Type localVarReturnType = new TypeToken<GetDefiInfoResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDefiInfoUsingGETAsync(String contractAddresses, String chainId, String authorization, final ApiCallback<GetDefiInfoResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDefiInfoUsingGETValidateBeforeCall(contractAddresses, chainId, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetDefiInfoResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

