/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import io.gopluslabs.client.ApiCallback;
import io.gopluslabs.client.ApiClient;
import io.gopluslabs.client.ApiException;
import io.gopluslabs.client.ApiResponse;
import io.gopluslabs.client.Configuration;
import io.gopluslabs.client.Pair;
import io.gopluslabs.client.ProgressRequestBody;
import io.gopluslabs.client.ProgressResponseBody;
import io.gopluslabs.client.model.ResponseWrapperAddressContract;
import io.gopluslabs.client.model.ResponseWrapperContractApproveResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ApproveControllerV1Api {
    private ApiClient apiClient;

    public ApproveControllerV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ApproveControllerV1Api(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addressContractUsingGET1Call(String address, String authorization, String chainId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/address_security/{address}".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (chainId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("chain_id", chainId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addressContractUsingGET1ValidateBeforeCall(String address, String authorization, String chainId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling addressContractUsingGET1(Async)");
        }
        Call call = this.addressContractUsingGET1Call(address, authorization, chainId, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperAddressContract addressContractUsingGET1(String address, String authorization, String chainId) throws ApiException {
        ApiResponse<ResponseWrapperAddressContract> resp = this.addressContractUsingGET1WithHttpInfo(address, authorization, chainId);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperAddressContract> addressContractUsingGET1WithHttpInfo(String address, String authorization, String chainId) throws ApiException {
        Call call = this.addressContractUsingGET1ValidateBeforeCall(address, authorization, chainId, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperAddressContract>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addressContractUsingGET1Async(String address, String authorization, String chainId, final ApiCallback<ResponseWrapperAddressContract> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addressContractUsingGET1ValidateBeforeCall(address, authorization, chainId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperAddressContract>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call approvalContractUsingGETCall(String chainId, String contractAddresses, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/approval_security/{chain_id}".replaceAll("\\{chain_id\\}", this.apiClient.escapeString(chainId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contract_addresses", contractAddresses));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call approvalContractUsingGETValidateBeforeCall(String chainId, String contractAddresses, String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling approvalContractUsingGET(Async)");
        }
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling approvalContractUsingGET(Async)");
        }
        Call call = this.approvalContractUsingGETCall(chainId, contractAddresses, authorization, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperContractApproveResponse approvalContractUsingGET(String chainId, String contractAddresses, String authorization) throws ApiException {
        ApiResponse<ResponseWrapperContractApproveResponse> resp = this.approvalContractUsingGETWithHttpInfo(chainId, contractAddresses, authorization);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperContractApproveResponse> approvalContractUsingGETWithHttpInfo(String chainId, String contractAddresses, String authorization) throws ApiException {
        Call call = this.approvalContractUsingGETValidateBeforeCall(chainId, contractAddresses, authorization, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperContractApproveResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call approvalContractUsingGETAsync(String chainId, String contractAddresses, String authorization, final ApiCallback<ResponseWrapperContractApproveResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.approvalContractUsingGETValidateBeforeCall(chainId, contractAddresses, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperContractApproveResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

