/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContractApproveResponse {
    @SerializedName(value="contract_name")
    private String contractName = null;
    @SerializedName(value="creator_address")
    private String creatorAddress = null;
    @SerializedName(value="deployed_time")
    private Long deployedTime = null;
    @SerializedName(value="doubt_list")
    private Integer doubtList = null;
    @SerializedName(value="is_contract")
    private Integer isContract = null;
    @SerializedName(value="is_open_source")
    private Integer isOpenSource = null;
    @SerializedName(value="is_proxy")
    private Integer isProxy = null;
    @SerializedName(value="malicious_behavior")
    private List<String> maliciousBehavior = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="trust_list")
    private Integer trustList = null;

    public ContractApproveResponse contractName(String contractName) {
        this.contractName = contractName;
        return this;
    }

    @Schema(description="It describes the approved contract name.")
    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public ContractApproveResponse creatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
        return this;
    }

    @Schema(description="It describes the creator address of the contract.(Notice:When the address is not a contract (\"is_contract\"=0), it will return \"null\".)")
    public String getCreatorAddress() {
        return this.creatorAddress;
    }

    public void setCreatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
    }

    public ContractApproveResponse deployedTime(Long deployedTime) {
        this.deployedTime = deployedTime;
        return this;
    }

    @Schema(description="It describes the deployed time of the contract. The value is presented as a timestamp. Example: \"deployed_time\": 1626578345(Notice:When the address is not a contract (\"is_contract\"=0), it will return \"null\".)")
    public Long getDeployedTime() {
        return this.deployedTime;
    }

    public void setDeployedTime(Long deployedTime) {
        this.deployedTime = deployedTime;
    }

    public ContractApproveResponse doubtList(Integer doubtList) {
        this.doubtList = doubtList;
        return this;
    }

    @Schema(description="It describes whether the address is a suspected malicious contract. \"1\" means true; \"0\" means that we have not found malicious behavior of this address.(Notice:Return \"0\" does not mean it is safe. Maybe we just haven't found its malicious behavior.)")
    public Integer getDoubtList() {
        return this.doubtList;
    }

    public void setDoubtList(Integer doubtList) {
        this.doubtList = doubtList;
    }

    public ContractApproveResponse isContract(Integer isContract) {
        this.isContract = isContract;
        return this;
    }

    @Schema(description="It describes whether the address is a contract. \"1\" means true; \"0\" means false.")
    public Integer getIsContract() {
        return this.isContract;
    }

    public void setIsContract(Integer isContract) {
        this.isContract = isContract;
    }

    public ContractApproveResponse isOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
        return this;
    }

    @Schema(description="It describes whether this contract is open source. \"1\" means true; \"0\" means false.(Notice:When the address is not a contract (\"is_contract\"=0), it will return \"null\".)")
    public Integer getIsOpenSource() {
        return this.isOpenSource;
    }

    public void setIsOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
    }

    public ContractApproveResponse isProxy(Integer isProxy) {
        this.isProxy = isProxy;
        return this;
    }

    @Schema(description="Whether the spender is a proxy contract.")
    public Integer getIsProxy() {
        return this.isProxy;
    }

    public void setIsProxy(Integer isProxy) {
        this.isProxy = isProxy;
    }

    public ContractApproveResponse maliciousBehavior(List<String> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
        return this;
    }

    public ContractApproveResponse addMaliciousBehaviorItem(String maliciousBehaviorItem) {
        if (this.maliciousBehavior == null) {
            this.maliciousBehavior = new ArrayList<String>();
        }
        this.maliciousBehavior.add(maliciousBehaviorItem);
        return this;
    }

    @Schema(description="It describes specific malicious behaviors. \"honeypot_related_address\" means that the address is related to honeypot tokens or has created scam tokens. \"phishing_activities\" means that this address has implemented phishing activities. \"blackmail_activities\" means that this address has implemented blackmail activities. \"stealing_attack\" means that this address has implemented stealing attacks. \"fake_kyc\" means that this address is involved in fake KYC. \"malicious_mining_activities\" means that this address is involved in malicious mining activities. \"darkweb_transactions\" means that this address is involved in darkweb transactions. \"cybercrime\" means that this address is involved in cybercrime. \"money_laundering\" means that this address is involved in money laundering. \"financial_crime\" means that this address is involved in financial crime. \"blacklist_doubt\" means that the address is suspected of malicious behavior and is therefore blacklisted.(Notice:Returning an empty array means that no malicious behavior was found at that address.)")
    public List<String> getMaliciousBehavior() {
        return this.maliciousBehavior;
    }

    public void setMaliciousBehavior(List<String> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
    }

    public ContractApproveResponse tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Schema(description="It describes which dapp uses the contract. Example:\"tag\": \"Compound\"")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ContractApproveResponse trustList(Integer trustList) {
        this.trustList = trustList;
        return this;
    }

    @Schema(description="It describes whether the address is a famous and trustworthy one. \"1\" means true; \"0\" means that we have not included this address in the trusted list;(Notice:Return \"0\" does not mean the address is not trustworthy. Maybe we just haven't included it yet.)")
    public Integer getTrustList() {
        return this.trustList;
    }

    public void setTrustList(Integer trustList) {
        this.trustList = trustList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractApproveResponse contractApproveResponse = (ContractApproveResponse)o;
        return Objects.equals(this.contractName, contractApproveResponse.contractName) && Objects.equals(this.creatorAddress, contractApproveResponse.creatorAddress) && Objects.equals(this.deployedTime, contractApproveResponse.deployedTime) && Objects.equals(this.doubtList, contractApproveResponse.doubtList) && Objects.equals(this.isContract, contractApproveResponse.isContract) && Objects.equals(this.isOpenSource, contractApproveResponse.isOpenSource) && Objects.equals(this.isProxy, contractApproveResponse.isProxy) && Objects.equals(this.maliciousBehavior, contractApproveResponse.maliciousBehavior) && Objects.equals(this.tag, contractApproveResponse.tag) && Objects.equals(this.trustList, contractApproveResponse.trustList);
    }

    public int hashCode() {
        return Objects.hash(this.contractName, this.creatorAddress, this.deployedTime, this.doubtList, this.isContract, this.isOpenSource, this.isProxy, this.maliciousBehavior, this.tag, this.trustList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractApproveResponse {\n");
        sb.append("    contractName: ").append(this.toIndentedString(this.contractName)).append("\n");
        sb.append("    creatorAddress: ").append(this.toIndentedString(this.creatorAddress)).append("\n");
        sb.append("    deployedTime: ").append(this.toIndentedString(this.deployedTime)).append("\n");
        sb.append("    doubtList: ").append(this.toIndentedString(this.doubtList)).append("\n");
        sb.append("    isContract: ").append(this.toIndentedString(this.isContract)).append("\n");
        sb.append("    isOpenSource: ").append(this.toIndentedString(this.isOpenSource)).append("\n");
        sb.append("    isProxy: ").append(this.toIndentedString(this.isProxy)).append("\n");
        sb.append("    maliciousBehavior: ").append(this.toIndentedString(this.maliciousBehavior)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    trustList: ").append(this.toIndentedString(this.trustList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

