/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client;

import io.gopluslabs.client.ApiClient;
import io.gopluslabs.client.ApiException;
import io.gopluslabs.client.api.ApproveControllerV1Api;
import io.gopluslabs.client.api.ApproveControllerV2Api;
import io.gopluslabs.client.api.ContractAbiControllerApi;
import io.gopluslabs.client.api.DappControllerApi;
import io.gopluslabs.client.api.DefiControllerApi;
import io.gopluslabs.client.api.NftControllerApi;
import io.gopluslabs.client.api.TokenControllerApi;
import io.gopluslabs.client.api.TokenControllerV1Api;
import io.gopluslabs.client.api.WebsiteControllerApi;
import io.gopluslabs.client.model.GetAccessTokenRequest;
import io.gopluslabs.client.model.GetDefiInfoResponse;
import io.gopluslabs.client.model.ParseAbiDataRequest;
import io.gopluslabs.client.model.ResponseWrapperAddressContract;
import io.gopluslabs.client.model.ResponseWrapperContractApproveResponse;
import io.gopluslabs.client.model.ResponseWrapperDappContractSecurityResponse;
import io.gopluslabs.client.model.ResponseWrapperGetAccessTokenResponse;
import io.gopluslabs.client.model.ResponseWrapperGetNftInfo;
import io.gopluslabs.client.model.ResponseWrapperListApproveNFT1155ListResponse;
import io.gopluslabs.client.model.ResponseWrapperListApproveNFTListResponse;
import io.gopluslabs.client.model.ResponseWrapperListApproveTokenOutListResponse;
import io.gopluslabs.client.model.ResponseWrapperListGetChainsList;
import io.gopluslabs.client.model.ResponseWrapperParseAbiDataResponse;
import io.gopluslabs.client.model.ResponseWrapperPhishingSite;
import io.gopluslabs.client.model.ResponseWrapperTokenSecurity;
import io.gopluslabs.client.request.AccessTokenRequest;
import io.gopluslabs.client.request.AddressSecurityRequest;
import io.gopluslabs.client.request.ApprovalSecurityRequest;
import io.gopluslabs.client.request.DappSecurityRequest;
import io.gopluslabs.client.request.DefiInfoRequest;
import io.gopluslabs.client.request.Erc1155ApprovalSecurityRequest;
import io.gopluslabs.client.request.Erc20ApprovalSecurityRequest;
import io.gopluslabs.client.request.Erc721ApprovalSecurityRequest;
import io.gopluslabs.client.request.InputDecodeRequest;
import io.gopluslabs.client.request.NftSecurityRequest;
import io.gopluslabs.client.request.PhishingSiteRequest;
import io.gopluslabs.client.request.SupportedChainsRequest;
import io.gopluslabs.client.request.TokenSecurityRequest;
import io.gopluslabs.client.response.AccessToken;
import io.gopluslabs.client.response.AddressContract;
import io.gopluslabs.client.response.ApproveNFT1155List;
import io.gopluslabs.client.response.ApproveNFTList;
import io.gopluslabs.client.response.ApproveTokenOutList;
import io.gopluslabs.client.response.ChainsList;
import io.gopluslabs.client.response.ContractApprove;
import io.gopluslabs.client.response.DappContractSecurity;
import io.gopluslabs.client.response.DefiInfo;
import io.gopluslabs.client.response.NftInfo;
import io.gopluslabs.client.response.ParseAbiData;
import io.gopluslabs.client.response.PhishingSite;
import io.gopluslabs.client.response.TokenSecurity;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class GoPlusClient {
    public static AccessToken getAccessToken(AccessTokenRequest request) throws ApiException {
        TokenControllerApi api = new TokenControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest();
        getAccessTokenRequest.setAppKey(request.getRequest().getAppKey());
        getAccessTokenRequest.setSign(request.getRequest().getSign());
        getAccessTokenRequest.setTime(request.getRequest().getTime());
        ResponseWrapperGetAccessTokenResponse accessTokenUsingPOST = api.getAccessTokenUsingPOST(getAccessTokenRequest);
        return AccessToken.of(accessTokenUsingPOST);
    }

    public static ChainsList supportedChains(SupportedChainsRequest request) throws ApiException {
        TokenControllerV1Api api = new TokenControllerV1Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperListGetChainsList chainsListUsingGET = api.getChainsListUsingGET(request.getAuthorization(), request.getName());
        return ChainsList.of(chainsListUsingGET);
    }

    public static TokenSecurity tokenSecurity(TokenSecurityRequest request) throws ApiException {
        TokenControllerV1Api api = new TokenControllerV1Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperTokenSecurity tokenSecurity = api.tokenSecurityUsingGET1(request.getChainId(), request.getAddress(), request.getAuthorization());
        return TokenSecurity.of(tokenSecurity);
    }

    public static AddressContract addressSecurity(AddressSecurityRequest request) throws ApiException {
        ApproveControllerV1Api api = new ApproveControllerV1Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperAddressContract addressContract = api.addressContractUsingGET1(request.getAddress(), request.getAuthorization(), request.getChainId());
        return AddressContract.of(addressContract);
    }

    public static ContractApprove approvalSecurity(ApprovalSecurityRequest request) throws ApiException {
        ApproveControllerV1Api api = new ApproveControllerV1Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperContractApproveResponse contractApprove = api.approvalContractUsingGET(request.getChainId(), request.getAddress(), request.getAuthorization());
        return ContractApprove.of(contractApprove);
    }

    public static ApproveTokenOutList erc20ApprovalSecurity(Erc20ApprovalSecurityRequest request) throws ApiException {
        ApproveControllerV2Api api = new ApproveControllerV2Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperListApproveTokenOutListResponse response = api.addressTokenApproveListUsingGET1(request.getAddress(), request.getChainId(), request.getAuthorization());
        return ApproveTokenOutList.of(response);
    }

    public static ApproveNFTList erc721ApprovalSecurity(Erc721ApprovalSecurityRequest request) throws ApiException {
        ApproveControllerV2Api api = new ApproveControllerV2Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperListApproveNFTListResponse response = api.addressNFT721ApproveListUsingGET1(request.getAddress(), request.getChainId(), request.getAuthorization());
        return ApproveNFTList.of(response);
    }

    public static ApproveNFT1155List erc1155ApprovalSecurity(Erc1155ApprovalSecurityRequest request) throws ApiException {
        ApproveControllerV2Api api = new ApproveControllerV2Api();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperListApproveNFT1155ListResponse response = api.addressNFT1155ApproveListUsingGET1(request.getAddress(), request.getChainId(), request.getAuthorization());
        return ApproveNFT1155List.of(response);
    }

    public static ParseAbiData inputDecode(InputDecodeRequest request) throws ApiException {
        ContractAbiControllerApi api = new ContractAbiControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ParseAbiDataRequest parseAbiDataRequest = new ParseAbiDataRequest();
        parseAbiDataRequest.setData(request.getBody().getData());
        parseAbiDataRequest.setChainId(request.getBody().getChainId());
        parseAbiDataRequest.setContractAddress(request.getBody().getContractAddress());
        parseAbiDataRequest.setSigner(request.getBody().getSigner());
        ResponseWrapperParseAbiDataResponse abiData = api.getAbiDataInfoUsingPOST(parseAbiDataRequest, request.getAuthorization());
        return ParseAbiData.of(abiData);
    }

    public static NftInfo nftSecurity(NftSecurityRequest request) throws ApiException {
        NftControllerApi api = new NftControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperGetNftInfo nftInfo = api.getNftInfoUsingGET1(request.getChainId(), request.getAddress(), request.getAuthorization(), request.getTokenId());
        return NftInfo.of(nftInfo);
    }

    public static DappContractSecurity dappSecurity(DappSecurityRequest request) throws ApiException {
        DappControllerApi api = new DappControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperDappContractSecurityResponse response = api.getDappInfoUsingGET(request.getAuthorization(), request.getUrl());
        return DappContractSecurity.of(response);
    }

    public static PhishingSite phishingSite(PhishingSiteRequest request) throws ApiException {
        WebsiteControllerApi api = new WebsiteControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        ResponseWrapperPhishingSite response = api.phishingSiteUsingGET(request.getUrl(), request.getAuthorization());
        return PhishingSite.of(response);
    }

    public static DefiInfo rugpullDetecting(DefiInfoRequest request) throws ApiException {
        DefiControllerApi api = new DefiControllerApi();
        api.setApiClient(GoPlusClient.createApiClient(request.getTimeout()));
        GetDefiInfoResponse defiInfoUsingGET = api.getDefiInfoUsingGET(request.getAddress(), request.getChainId(), request.getAuthorization());
        return DefiInfo.of(defiInfoUsingGET);
    }

    private static ApiClient createApiClient(Integer timeOut) {
        ApiClient apiClient = new ApiClient();
        OkHttpClient httpClient = apiClient.getHttpClient();
        OkHttpClient build = httpClient.newBuilder().readTimeout(timeOut == null ? 60000L : (long)timeOut.intValue(), TimeUnit.MILLISECONDS).build();
        apiClient.setHttpClient(build);
        return apiClient;
    }
}

