/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class ResponseWrapperTokenSecurityNFTList {
    @SerializedName(value="NFT_percentage")
    private String nfTPercentage = null;
    @SerializedName(value="NFT_id")
    private String nfTId = null;
    @SerializedName(value="amount")
    private String amount = null;
    @SerializedName(value="in_effect")
    private String inEffect = null;
    @SerializedName(value="value")
    private String value = null;

    public ResponseWrapperTokenSecurityNFTList nfTPercentage(String nfTPercentage) {
        this.nfTPercentage = nfTPercentage;
        return this;
    }

    @Schema(description="\"NFT_percentage\" represents the proportion of that NFT in the total liquidity. When the LP holder is a lockup address, this information will also appear in the \"locked_detail\" section.")
    public String getNfTPercentage() {
        return this.nfTPercentage;
    }

    public void setNfTPercentage(String nfTPercentage) {
        this.nfTPercentage = nfTPercentage;
    }

    public ResponseWrapperTokenSecurityNFTList nfTId(String nfTId) {
        this.nfTId = nfTId;
        return this;
    }

    @Schema(description="\"NFT_id\" is the NFTID corresponding to that NFT. ")
    public String getNfTId() {
        return this.nfTId;
    }

    public void setNfTId(String nfTId) {
        this.nfTId = nfTId;
    }

    public ResponseWrapperTokenSecurityNFTList amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Schema(description="\"amount\" is the liquidity quantity corresponding to the NFT.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ResponseWrapperTokenSecurityNFTList inEffect(String inEffect) {
        this.inEffect = inEffect;
        return this;
    }

    @Schema(description="\"in_effect\" indicates whether the liquidity corresponding to that NFT is effective at the current price. ")
    public String getInEffect() {
        return this.inEffect;
    }

    public void setInEffect(String inEffect) {
        this.inEffect = inEffect;
    }

    public ResponseWrapperTokenSecurityNFTList value(String value) {
        this.value = value;
        return this;
    }

    @Schema(description="\"value\" is the total USD value corresponding to the NFT.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseWrapperTokenSecurityNFTList responseWrapperTokenSecurityNFTList = (ResponseWrapperTokenSecurityNFTList)o;
        return Objects.equals(this.nfTPercentage, responseWrapperTokenSecurityNFTList.nfTPercentage) && Objects.equals(this.nfTId, responseWrapperTokenSecurityNFTList.nfTId) && Objects.equals(this.amount, responseWrapperTokenSecurityNFTList.amount) && Objects.equals(this.inEffect, responseWrapperTokenSecurityNFTList.inEffect) && Objects.equals(this.value, responseWrapperTokenSecurityNFTList.value);
    }

    public int hashCode() {
        return Objects.hash(this.nfTPercentage, this.nfTId, this.amount, this.inEffect, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseWrapperTokenSecurityNFTList {\n");
        sb.append("    nfTPercentage: ").append(this.toIndentedString(this.nfTPercentage)).append("\n");
        sb.append("    nfTId: ").append(this.toIndentedString(this.nfTId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    inEffect: ").append(this.toIndentedString(this.inEffect)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

