/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="It describes whether the NFT owner can transfer NFT without approval.(Notice:Transfer_without_approval generally means the scammer does not need to get approvals to transfer another address's NFT. One typical example is sleep_minting. Sleep_minting means that the scammer will first add the NFT to a well-known wallet address and then retrieve the NFT. After the value of the NFT has appreciated , it will be put back on the market.)")
public class ResponseWrapperGetNftInfoResultTransferWithoutApproval {
    @SerializedName(value="owner_address")
    private String ownerAddress = null;
    @SerializedName(value="value")
    private Integer value = null;
    @SerializedName(value="owner_type")
    private String ownerType = null;

    public ResponseWrapperGetNftInfoResultTransferWithoutApproval ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    @Schema(description="Owner_address describes the owner address.  null: the owner address cannot be fetched.")
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public ResponseWrapperGetNftInfoResultTransferWithoutApproval value(Integer value) {
        this.value = value;
        return this;
    }

    @Schema(description="The \"value\" describes the status of the risk. null: the contract is not open source or there is a proxy, it is not possible to detect whether the risk exists. -1: the risk is detected but the ownership give up. If the detection of a code vulnerability, it can also be considered risk-free.  0: the risk is not detected.  1: the risk is detected, and the owner address is a common address (EOA), then it can be said that there is a clear risk.  2: The risk is detected, but the owner address is a contract address, the risk is not significant.  3: The risk is detected, but the owner address is not detectable / or an array. ")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public ResponseWrapperGetNftInfoResultTransferWithoutApproval ownerType(String ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Schema(description="\"blackhole\" : the owner is a blackhole address. \"contract\" : the owner is a contract. \"eoa\" : the owner is a common address (eoa). \"multi-address\": the owner is an array/list. null: the address is not detected.")
    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseWrapperGetNftInfoResultTransferWithoutApproval responseWrapperGetNftInfoResultTransferWithoutApproval = (ResponseWrapperGetNftInfoResultTransferWithoutApproval)o;
        return Objects.equals(this.ownerAddress, responseWrapperGetNftInfoResultTransferWithoutApproval.ownerAddress) && Objects.equals(this.value, responseWrapperGetNftInfoResultTransferWithoutApproval.value) && Objects.equals(this.ownerType, responseWrapperGetNftInfoResultTransferWithoutApproval.ownerType);
    }

    public int hashCode() {
        return Objects.hash(this.ownerAddress, this.value, this.ownerType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseWrapperGetNftInfoResultTransferWithoutApproval {\n");
        sb.append("    ownerAddress: ").append(this.toIndentedString(this.ownerAddress)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString(this.ownerType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

