/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ParseAbiDataRequest {
    @SerializedName(value="chain_id")
    private String chainId = null;
    @SerializedName(value="contract_address")
    private String contractAddress = null;
    @SerializedName(value="data")
    private String data = null;
    @SerializedName(value="input")
    private Map<String, Object> input = null;
    @SerializedName(value="signer")
    private String signer = null;
    @SerializedName(value="transcation_type")
    private TranscationTypeEnum transcationType = null;

    public ParseAbiDataRequest chainId(String chainId) {
        this.chainId = chainId;
        return this;
    }

    @Schema(example="56", required=true, description="Chain id, (ETH: 1, Cronos:25, BSC: 56, Heco: 128, Polygon: 137, Fantom:250, KCC: 321, Arbitrum: 42161, Avalanche: 43114)")
    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ParseAbiDataRequest contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @Schema(example="489982930986835137684486657990555633941558688085", description="Carrying the signer and contract address will help to decode more information.")
    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public ParseAbiDataRequest data(String data) {
        this.data = data;
        return this;
    }

    @Schema(example="38020752995870066111790065015062961812328902090107696250858266643344188923832740441241402799828641949243718670476236652057420675249926299203332389775628687908012032", required=true, description="Transaction input")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public ParseAbiDataRequest input(Map<String, Object> input) {
        this.input = input;
        return this;
    }

    public ParseAbiDataRequest putInputItem(String key, Object inputItem) {
        if (this.input == null) {
            this.input = new HashMap<String, Object>();
        }
        this.input.put(key, inputItem);
        return this;
    }

    @Schema(example="{}", description="input info")
    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public ParseAbiDataRequest signer(String signer) {
        this.signer = signer;
        return this;
    }

    @Schema(description="Carrying the signer and contract address will help to decode more information.")
    public String getSigner() {
        return this.signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public ParseAbiDataRequest transcationType(TranscationTypeEnum transcationType) {
        this.transcationType = transcationType;
        return this;
    }

    @Schema(description="Transaction type")
    public TranscationTypeEnum getTranscationType() {
        return this.transcationType;
    }

    public void setTranscationType(TranscationTypeEnum transcationType) {
        this.transcationType = transcationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseAbiDataRequest parseAbiDataRequest = (ParseAbiDataRequest)o;
        return Objects.equals(this.chainId, parseAbiDataRequest.chainId) && Objects.equals(this.contractAddress, parseAbiDataRequest.contractAddress) && Objects.equals(this.data, parseAbiDataRequest.data) && Objects.equals(this.input, parseAbiDataRequest.input) && Objects.equals(this.signer, parseAbiDataRequest.signer) && Objects.equals((Object)this.transcationType, (Object)parseAbiDataRequest.transcationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chainId, this.contractAddress, this.data, this.input, this.signer, this.transcationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParseAbiDataRequest {\n");
        sb.append("    chainId: ").append(this.toIndentedString(this.chainId)).append("\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    signer: ").append(this.toIndentedString(this.signer)).append("\n");
        sb.append("    transcationType: ").append(this.toIndentedString((Object)this.transcationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TranscationTypeEnum {
        COMMON("common"),
        ETH_SIGNTYPEDDATA_V4("eth_signTypedData_v4"),
        PERSONAL_SIGN("personal_sign"),
        ETH_SIGN("eth_sign");

        private String value;

        private TranscationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TranscationTypeEnum fromValue(String input) {
            for (TranscationTypeEnum b : TranscationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TranscationTypeEnum> {
            public void write(JsonWriter jsonWriter, TranscationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TranscationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TranscationTypeEnum.fromValue(value);
            }
        }
    }
}

