/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Contracts {
    @SerializedName(value="contract_address")
    private String contractAddress = null;
    @SerializedName(value="creator_address")
    private String creatorAddress = null;
    @SerializedName(value="deployment_time")
    private Long deploymentTime = null;
    @SerializedName(value="is_open_source")
    private Integer isOpenSource = null;
    @SerializedName(value="malicious_behavior")
    private List<Object> maliciousBehavior = null;
    @SerializedName(value="malicious_contract")
    private Integer maliciousContract = null;
    @SerializedName(value="malicious_creator")
    private Integer maliciousCreator = null;
    @SerializedName(value="malicious_creator_behavior")
    private List<Object> maliciousCreatorBehavior = null;

    public Contracts contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @Schema(description="It describes the dAap's contract address.")
    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public Contracts creatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
        return this;
    }

    @Schema(description="It describes the creator address of the contract.")
    public String getCreatorAddress() {
        return this.creatorAddress;
    }

    public void setCreatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
    }

    public Contracts deploymentTime(Long deploymentTime) {
        this.deploymentTime = deploymentTime;
        return this;
    }

    @Schema(description="It describes the deployed time of the contract.The value is presented as a timestamp. Example: \"deployed_time\": 1626578345")
    public Long getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Long deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public Contracts isOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
        return this;
    }

    @Schema(description="It describes whether this contract is open source. \"1\" means true; \"0\" means false.")
    public Integer getIsOpenSource() {
        return this.isOpenSource;
    }

    public void setIsOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
    }

    public Contracts maliciousBehavior(List<Object> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
        return this;
    }

    public Contracts addMaliciousBehaviorItem(Object maliciousBehaviorItem) {
        if (this.maliciousBehavior == null) {
            this.maliciousBehavior = new ArrayList<Object>();
        }
        this.maliciousBehavior.add(maliciousBehaviorItem);
        return this;
    }

    @Schema(description="It describes specific malicious behaviors of the contract.")
    public List<Object> getMaliciousBehavior() {
        return this.maliciousBehavior;
    }

    public void setMaliciousBehavior(List<Object> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
    }

    public Contracts maliciousContract(Integer maliciousContract) {
        this.maliciousContract = maliciousContract;
        return this;
    }

    @Schema(description="It describes whether the address is a suspected malicious contract. \"1\" means true; \"0\" means that we have not found malicious behavior of this contract.(Notice:\"malicious_contract\" return \"0\" does not mean the address is completely safe. Maybe we just haven't found its malicious behavior.)")
    public Integer getMaliciousContract() {
        return this.maliciousContract;
    }

    public void setMaliciousContract(Integer maliciousContract) {
        this.maliciousContract = maliciousContract;
    }

    public Contracts maliciousCreator(Integer maliciousCreator) {
        this.maliciousCreator = maliciousCreator;
        return this;
    }

    @Schema(description="It describes whether the creator is a suspected malicious address. \"1\" means true; \"0\" means that we have not found malicious behavior of this address.(Notice:\"malicious_creator\" return \"0\" does not mean the address is completely safe. Maybe we just haven't found its malicious behavior.)")
    public Integer getMaliciousCreator() {
        return this.maliciousCreator;
    }

    public void setMaliciousCreator(Integer maliciousCreator) {
        this.maliciousCreator = maliciousCreator;
    }

    public Contracts maliciousCreatorBehavior(List<Object> maliciousCreatorBehavior) {
        this.maliciousCreatorBehavior = maliciousCreatorBehavior;
        return this;
    }

    public Contracts addMaliciousCreatorBehaviorItem(Object maliciousCreatorBehaviorItem) {
        if (this.maliciousCreatorBehavior == null) {
            this.maliciousCreatorBehavior = new ArrayList<Object>();
        }
        this.maliciousCreatorBehavior.add(maliciousCreatorBehaviorItem);
        return this;
    }

    @Schema(description="It describes specific malicious behaviors of the contract creator.")
    public List<Object> getMaliciousCreatorBehavior() {
        return this.maliciousCreatorBehavior;
    }

    public void setMaliciousCreatorBehavior(List<Object> maliciousCreatorBehavior) {
        this.maliciousCreatorBehavior = maliciousCreatorBehavior;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contracts contracts = (Contracts)o;
        return Objects.equals(this.contractAddress, contracts.contractAddress) && Objects.equals(this.creatorAddress, contracts.creatorAddress) && Objects.equals(this.deploymentTime, contracts.deploymentTime) && Objects.equals(this.isOpenSource, contracts.isOpenSource) && Objects.equals(this.maliciousBehavior, contracts.maliciousBehavior) && Objects.equals(this.maliciousContract, contracts.maliciousContract) && Objects.equals(this.maliciousCreator, contracts.maliciousCreator) && Objects.equals(this.maliciousCreatorBehavior, contracts.maliciousCreatorBehavior);
    }

    public int hashCode() {
        return Objects.hash(this.contractAddress, this.creatorAddress, this.deploymentTime, this.isOpenSource, this.maliciousBehavior, this.maliciousContract, this.maliciousCreator, this.maliciousCreatorBehavior);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contracts {\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("    creatorAddress: ").append(this.toIndentedString(this.creatorAddress)).append("\n");
        sb.append("    deploymentTime: ").append(this.toIndentedString(this.deploymentTime)).append("\n");
        sb.append("    isOpenSource: ").append(this.toIndentedString(this.isOpenSource)).append("\n");
        sb.append("    maliciousBehavior: ").append(this.toIndentedString(this.maliciousBehavior)).append("\n");
        sb.append("    maliciousContract: ").append(this.toIndentedString(this.maliciousContract)).append("\n");
        sb.append("    maliciousCreator: ").append(this.toIndentedString(this.maliciousCreator)).append("\n");
        sb.append("    maliciousCreatorBehavior: ").append(this.toIndentedString(this.maliciousCreatorBehavior)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

