/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApproveAddressInfo {
    @SerializedName(value="contract_name")
    private String contractName = null;
    @SerializedName(value="creator_address")
    private String creatorAddress = null;
    @SerializedName(value="deployed_time")
    private Long deployedTime = null;
    @SerializedName(value="doubt_list")
    private Integer doubtList = null;
    @SerializedName(value="is_contract")
    private Integer isContract = null;
    @SerializedName(value="is_open_source")
    private Integer isOpenSource = null;
    @SerializedName(value="malicious_behavior")
    private List<String> maliciousBehavior = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="trust_list")
    private Integer trustList = null;

    public ApproveAddressInfo contractName(String contractName) {
        this.contractName = contractName;
        return this;
    }

    @Schema(description="Spender name")
    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public ApproveAddressInfo creatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
        return this;
    }

    @Schema(description="Spender's deployer")
    public String getCreatorAddress() {
        return this.creatorAddress;
    }

    public void setCreatorAddress(String creatorAddress) {
        this.creatorAddress = creatorAddress;
    }

    public ApproveAddressInfo deployedTime(Long deployedTime) {
        this.deployedTime = deployedTime;
        return this;
    }

    @Schema(description="Spender's deployed time")
    public Long getDeployedTime() {
        return this.deployedTime;
    }

    public void setDeployedTime(Long deployedTime) {
        this.deployedTime = deployedTime;
    }

    public ApproveAddressInfo doubtList(Integer doubtList) {
        this.doubtList = doubtList;
        return this;
    }

    @Schema(description="Whether the spender has a history of malicious behavior or contains high risk.")
    public Integer getDoubtList() {
        return this.doubtList;
    }

    public void setDoubtList(Integer doubtList) {
        this.doubtList = doubtList;
    }

    public ApproveAddressInfo isContract(Integer isContract) {
        this.isContract = isContract;
        return this;
    }

    @Schema(description="Whether the spender is a contract.")
    public Integer getIsContract() {
        return this.isContract;
    }

    public void setIsContract(Integer isContract) {
        this.isContract = isContract;
    }

    public ApproveAddressInfo isOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
        return this;
    }

    @Schema(description="Whether the spender is verified on blockchain explorer.")
    public Integer getIsOpenSource() {
        return this.isOpenSource;
    }

    public void setIsOpenSource(Integer isOpenSource) {
        this.isOpenSource = isOpenSource;
    }

    public ApproveAddressInfo maliciousBehavior(List<String> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
        return this;
    }

    public ApproveAddressInfo addMaliciousBehaviorItem(String maliciousBehaviorItem) {
        if (this.maliciousBehavior == null) {
            this.maliciousBehavior = new ArrayList<String>();
        }
        this.maliciousBehavior.add(maliciousBehaviorItem);
        return this;
    }

    @Schema(description="Specific malicious behaviors or risks of this spender.")
    public List<String> getMaliciousBehavior() {
        return this.maliciousBehavior;
    }

    public void setMaliciousBehavior(List<String> maliciousBehavior) {
        this.maliciousBehavior = maliciousBehavior;
    }

    public ApproveAddressInfo tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Schema(description="Spender tag")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ApproveAddressInfo trustList(Integer trustList) {
        this.trustList = trustList;
        return this;
    }

    @Schema(description="Whether the spender is on the whitelist, and can be trusted")
    public Integer getTrustList() {
        return this.trustList;
    }

    public void setTrustList(Integer trustList) {
        this.trustList = trustList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproveAddressInfo approveAddressInfo = (ApproveAddressInfo)o;
        return Objects.equals(this.contractName, approveAddressInfo.contractName) && Objects.equals(this.creatorAddress, approveAddressInfo.creatorAddress) && Objects.equals(this.deployedTime, approveAddressInfo.deployedTime) && Objects.equals(this.doubtList, approveAddressInfo.doubtList) && Objects.equals(this.isContract, approveAddressInfo.isContract) && Objects.equals(this.isOpenSource, approveAddressInfo.isOpenSource) && Objects.equals(this.maliciousBehavior, approveAddressInfo.maliciousBehavior) && Objects.equals(this.tag, approveAddressInfo.tag) && Objects.equals(this.trustList, approveAddressInfo.trustList);
    }

    public int hashCode() {
        return Objects.hash(this.contractName, this.creatorAddress, this.deployedTime, this.doubtList, this.isContract, this.isOpenSource, this.maliciousBehavior, this.tag, this.trustList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApproveAddressInfo {\n");
        sb.append("    contractName: ").append(this.toIndentedString(this.contractName)).append("\n");
        sb.append("    creatorAddress: ").append(this.toIndentedString(this.creatorAddress)).append("\n");
        sb.append("    deployedTime: ").append(this.toIndentedString(this.deployedTime)).append("\n");
        sb.append("    doubtList: ").append(this.toIndentedString(this.doubtList)).append("\n");
        sb.append("    isContract: ").append(this.toIndentedString(this.isContract)).append("\n");
        sb.append("    isOpenSource: ").append(this.toIndentedString(this.isOpenSource)).append("\n");
        sb.append("    maliciousBehavior: ").append(this.toIndentedString(this.maliciousBehavior)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    trustList: ").append(this.toIndentedString(this.trustList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

