/*
 * Decompiled with CFR 0.152.
 */
package io.gopluslabs.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.gopluslabs.client.ApiCallback;
import io.gopluslabs.client.ApiClient;
import io.gopluslabs.client.ApiException;
import io.gopluslabs.client.ApiResponse;
import io.gopluslabs.client.Configuration;
import io.gopluslabs.client.Pair;
import io.gopluslabs.client.ProgressRequestBody;
import io.gopluslabs.client.ProgressResponseBody;
import io.gopluslabs.client.model.ResponseWrapperGetNftInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class NftControllerApi {
    private ApiClient apiClient;

    public NftControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NftControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getNftInfoUsingGET1Call(String chainId, String contractAddresses, String authorization, String tokenId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/nft_security/{chain_id}".replaceAll("\\{chain_id\\}", this.apiClient.escapeString(chainId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contract_addresses", contractAddresses));
        }
        if (tokenId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("token_id", tokenId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNftInfoUsingGET1ValidateBeforeCall(String chainId, String contractAddresses, String authorization, String tokenId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling getNftInfoUsingGET1(Async)");
        }
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling getNftInfoUsingGET1(Async)");
        }
        Call call = this.getNftInfoUsingGET1Call(chainId, contractAddresses, authorization, tokenId, progressListener, progressRequestListener);
        return call;
    }

    public ResponseWrapperGetNftInfo getNftInfoUsingGET1(String chainId, String contractAddresses, String authorization, String tokenId) throws ApiException {
        ApiResponse<ResponseWrapperGetNftInfo> resp = this.getNftInfoUsingGET1WithHttpInfo(chainId, contractAddresses, authorization, tokenId);
        return resp.getData();
    }

    public ApiResponse<ResponseWrapperGetNftInfo> getNftInfoUsingGET1WithHttpInfo(String chainId, String contractAddresses, String authorization, String tokenId) throws ApiException {
        Call call = this.getNftInfoUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, tokenId, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetNftInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNftInfoUsingGET1Async(String chainId, String contractAddresses, String authorization, String tokenId, final ApiCallback<ResponseWrapperGetNftInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNftInfoUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, tokenId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetNftInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

