/*
 * GoPlus Security API Document
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package io.gopluslabs.client.api;

import io.gopluslabs.client.ApiCallback;
import io.gopluslabs.client.ApiClient;
import io.gopluslabs.client.ApiException;
import io.gopluslabs.client.ApiResponse;
import io.gopluslabs.client.Configuration;
import io.gopluslabs.client.Pair;
import io.gopluslabs.client.ProgressRequestBody;
import io.gopluslabs.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.gopluslabs.client.model.ResponseWrapperGetNftInfo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NftControllerApi {
    private ApiClient apiClient;

    public NftControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NftControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getNftInfoUsingGET1
     * @param chainId Chain id, (eth: 1, bsc: 56, Polygon: 137, Avalanche: 43114) (required)
     * @param contractAddresses NFT contract address (required)
     * @param authorization Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param tokenId tokenId (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getNftInfoUsingGET1Call(String chainId, String contractAddresses, String authorization, String tokenId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/api/v1/nft_security/{chain_id}"
            .replaceAll("\\{" + "chain_id" + "\\}", apiClient.escapeString(chainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contractAddresses != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("contract_addresses", contractAddresses));
        if (tokenId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("token_id", tokenId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null)
        localVarHeaderParams.put("Authorization", apiClient.parameterToString(authorization));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "*/*"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getNftInfoUsingGET1ValidateBeforeCall(String chainId, String contractAddresses, String authorization, String tokenId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'chainId' is set
        if (chainId == null) {
            throw new ApiException("Missing the required parameter 'chainId' when calling getNftInfoUsingGET1(Async)");
        }
        // verify the required parameter 'contractAddresses' is set
        if (contractAddresses == null) {
            throw new ApiException("Missing the required parameter 'contractAddresses' when calling getNftInfoUsingGET1(Async)");
        }
        
        com.squareup.okhttp.Call call = getNftInfoUsingGET1Call(chainId, contractAddresses, authorization, tokenId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get NFT&#x27;s security and risk data.
     * 
     * @param chainId Chain id, (eth: 1, bsc: 56, Polygon: 137, Avalanche: 43114) (required)
     * @param contractAddresses NFT contract address (required)
     * @param authorization Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param tokenId tokenId (optional)
     * @return ResponseWrapperGetNftInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ResponseWrapperGetNftInfo getNftInfoUsingGET1(String chainId, String contractAddresses, String authorization, String tokenId) throws ApiException {
        ApiResponse<ResponseWrapperGetNftInfo> resp = getNftInfoUsingGET1WithHttpInfo(chainId, contractAddresses, authorization, tokenId);
        return resp.getData();
    }

    /**
     * Get NFT&#x27;s security and risk data.
     * 
     * @param chainId Chain id, (eth: 1, bsc: 56, Polygon: 137, Avalanche: 43114) (required)
     * @param contractAddresses NFT contract address (required)
     * @param authorization Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param tokenId tokenId (optional)
     * @return ApiResponse&lt;ResponseWrapperGetNftInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ResponseWrapperGetNftInfo> getNftInfoUsingGET1WithHttpInfo(String chainId, String contractAddresses, String authorization, String tokenId) throws ApiException {
        com.squareup.okhttp.Call call = getNftInfoUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, tokenId, null, null);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetNftInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get NFT&#x27;s security and risk data. (asynchronously)
     * 
     * @param chainId Chain id, (eth: 1, bsc: 56, Polygon: 137, Avalanche: 43114) (required)
     * @param contractAddresses NFT contract address (required)
     * @param authorization Authorization (test：Bearer 81|9ihH8JzEuFu4MQ9DjWmH5WrNCPW...) (optional)
     * @param tokenId tokenId (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getNftInfoUsingGET1Async(String chainId, String contractAddresses, String authorization, String tokenId, final ApiCallback<ResponseWrapperGetNftInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getNftInfoUsingGET1ValidateBeforeCall(chainId, contractAddresses, authorization, tokenId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseWrapperGetNftInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
