/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.jdbc.AbstractTestcontainersJdbcExtension;
import io.goodforgod.testcontainers.extensions.jdbc.ClickhouseContext;
import io.goodforgod.testcontainers.extensions.jdbc.ConnectionClickhouse;
import io.goodforgod.testcontainers.extensions.jdbc.ContainerClickhouse;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMetadata;
import io.goodforgod.testcontainers.extensions.jdbc.TestcontainersClickhouse;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.testcontainers.clickhouse.ClickHouseContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

final class TestcontainersClickhouseExtension
extends AbstractTestcontainersJdbcExtension<ClickHouseContainer, JdbcMetadata> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersClickhouseExtension.class});

    TestcontainersClickhouseExtension() {
    }

    protected Class<ClickHouseContainer> getContainerType() {
        return ClickHouseContainer.class;
    }

    protected Class<? extends Annotation> getContainerAnnotation() {
        return ContainerClickhouse.class;
    }

    protected Class<? extends Annotation> getConnectionAnnotation() {
        return ConnectionClickhouse.class;
    }

    protected ExtensionContext.Namespace getNamespace() {
        return NAMESPACE;
    }

    protected ClickHouseContainer createContainerDefault(JdbcMetadata metadata) {
        DockerImageName image = DockerImageName.parse((String)metadata.image()).asCompatibleSubstituteFor(DockerImageName.parse((String)"yandex/clickhouse-server"));
        ClickHouseContainer container = new ClickHouseContainer(image);
        String alias = Optional.ofNullable(metadata.networkAlias()).orElseGet(() -> "clickhouse-" + System.currentTimeMillis());
        container.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(ClickHouseContainer.class)).withMdc("image", image.asCanonicalNameString()).withMdc("alias", alias));
        container.withDatabaseName("clickhouse");
        container.withUsername("clickhouse");
        container.withPassword("clickhouse");
        container.withStartupTimeout(Duration.ofSeconds(15L));
        container.setNetworkAliases(new ArrayList<String>(List.of(alias)));
        if (metadata.networkShared()) {
            container.withNetwork(Network.SHARED);
        }
        return container;
    }

    protected ContainerContext<JdbcConnection> createContainerContext(ClickHouseContainer container) {
        return new ClickhouseContext(container);
    }

    @NotNull
    protected Optional<JdbcMetadata> findMetadata(@NotNull ExtensionContext context) {
        return this.findAnnotation(TestcontainersClickhouse.class, context).map(a -> new JdbcMetadata(a.network().shared(), a.network().alias(), a.image(), a.mode(), a.migration()));
    }
}

